package ru.yandex.crypta.graph.api.service.settings;

import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph.api.service.TransformerGraphService;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.lib.proto.identifiers.ERepresentedObjectType;
import ru.yandex.crypta.lib.proto.identifiers.TIdType;
import ru.yandex.crypta.lib.yt.YtReadingUtils;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class YtSoupyIndeviceGraphSettings implements GraphSettings {
    private static final List<String> MATCH_TYPES = List.of("soupy_indevice");
    private static final List<String> SCOPES = List.of(
            "indevice_id",
            TransformerGraphService.MATCH_SCOPE_EXTEND_WITH_INNER_SOUP,
            TransformerGraphService.MATCH_SCOPE_EXTEND_WITH_SOUP
    );

    private static final List<String> ID_TYPES = Soup.CONFIG
            .getIdTypes()
            .getAll()
            .stream()
            .filter(idType -> {
                ERepresentedObjectType repObj = idType.getRepObj();
                return repObj.equals(ERepresentedObjectType.DEVICE)
                        || repObj.equals(ERepresentedObjectType.APP)
                        || repObj.equals(ERepresentedObjectType.BROWSER);
            })
            .filter(idType -> idType.getName() != null && !idType.getName().isEmpty())
            .map(TIdType::getName)
            .sorted()
            .collect(Collectors.toList());

    private static final SoupyIndeviceGraphPaths PATHS = new SoupyIndeviceGraphPaths(
            "//home/crypta/production/state/graph/v2/indevice"
    );

    @Override
    public List<String> getSupportedMatchTypes() {
        return MATCH_TYPES;
    }

    @Override
    public List<String> getSupportedScopes() {
        return SCOPES;
    }

    @Override
    public List<String> getSupportedIdTypes() {
        return ID_TYPES;
    }

    public SoupyIndeviceGraphPaths getPaths() {
        return PATHS;
    }

    public static class SoupyIndeviceGraphPaths {

        private YPath basePath;

        SoupyIndeviceGraphPaths(String absolutePath) {
            basePath = YPath.simple(absolutePath);
        }

        public YPath byId(GraphId graphId) {
            return basePath.child("last_by_id")
                    .withExact(YtReadingUtils.exact(graphId.toIdTypeKey()));
        }

        public YPath byIndeviceId(String hhId) {
            return basePath.child("last_by_indevice_id")
                    .withExact(YtReadingUtils.exact(hhId));
        }
    }
}
