package ru.yandex.crypta.graph.api.service.settings;

import java.util.List;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.crypta.graph.api.model.ids.GraphId;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.lib.proto.identifiers.EIdType;
import ru.yandex.crypta.lib.yt.YtReadingUtils;
import ru.yandex.inside.yt.kosher.cypress.YPath;

public class YtV1GraphSettings implements GraphSettings {
    public static final String MATCH_TYPE_v1_PROD = "v1_prod_yt";
    public static final String MATCH_SCOPE_CRYPTA_ID = "crypta_id";

    private static final ListF<String> MATCH_TYPES = Cf.list(MATCH_TYPE_v1_PROD);
    private static final ListF<String> MATCH_SCOPES = Cf.list(MATCH_SCOPE_CRYPTA_ID);
    private static final ListF<String> ID_TYPES = Cf.list(
            Soup.CONFIG.name(EIdType.YANDEXUID),
            Soup.CONFIG.name(EIdType.OLD_DEVICE_ID),
            GraphId.OLD_CRYPTA_ID_TYPE
    );

    private V1GraphPaths paths = new V1GraphPaths(
            "//home/crypta/production/state/graph/dicts/matching"
    );

    @Override
    public List<String> getSupportedMatchTypes() {
        return MATCH_TYPES;
    }

    @Override
    public List<String> getSupportedScopes() {
        return MATCH_SCOPES;
    }

    @Override
    public List<String> getSupportedIdTypes() {
        return ID_TYPES;
    }

    public V1GraphPaths getPaths() {
        return paths;
    }

    public static class V1GraphPaths {

        private YPath basePath;

        V1GraphPaths(String absolutePath) {
            basePath = YPath.simple(absolutePath);
        }

        public YPath getVerticesPath(GraphId graphId) {
            return basePath.child("exact_vertices_by_key")
                    .withExact(YtReadingUtils.exact(graphId.getIdValue()));
        }

        public YPath getEdgesPath(String cryptaId) {
            return basePath.child("exact_edges")
                    .withExact(YtReadingUtils.exact(cryptaId));
        }
    }
}
