package ru.yandex.crypta.graph.api.service.transformer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

import org.jgrapht.graph.WeightedMultigraph;

import ru.yandex.crypta.graph.api.model.graph.Edge;
import ru.yandex.crypta.graph.api.model.graph.Graph;
import ru.yandex.crypta.graph.api.model.graph.GraphComponent;
import ru.yandex.crypta.graph.api.model.graph.Vertex;

public interface GraphTransformer {

    WeightedMultigraph<Vertex, Edge> transform(WeightedMultigraph<Vertex, Edge> graph);

    default Graph transform(Graph graph) {
        List<GraphComponent> newComponents = graph.getGraphComponents().stream().map(component -> {
            WeightedMultigraph<Vertex, Edge> graphX = JGraphTHelper.toWeightedGraph(component.getEdges());

            WeightedMultigraph<Vertex, Edge> transformed = transform(graphX);

            return new GraphComponent(
                    component.getCryptaId(),
                    new ArrayList<>(transformed.vertexSet()),
                    new ArrayList<>(transformed.edgeSet())
            );

        }).collect(Collectors.toList());

        graph.setGraphComponents(newComponents);

        return graph;
    }
}
