package ru.yandex.crypta.graph.api.service.transformer;

import java.util.Set;
import java.util.stream.Collectors;

import org.jgrapht.graph.WeightedMultigraph;

import ru.yandex.crypta.graph.api.model.graph.Edge;
import ru.yandex.crypta.graph.api.model.graph.Vertex;
import ru.yandex.crypta.graph.soup.config.NoSuchEdgeException;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeType;

public class IndeviceGraphTransformer implements GraphTransformer {
    @Override
    public WeightedMultigraph<Vertex, Edge> transform(WeightedMultigraph<Vertex, Edge> graph) {
        Set<Edge> indeviceEdgeSet = graph.edgeSet().stream().filter(
                edge -> {
                    try {
                        TEdgeType edgeType = Soup.CONFIG.getEdgeType(
                                edge.getId1Type(),
                                edge.getId2Type(),
                                edge.getSourceType(),
                                edge.getLogSource()
                        );
                        TEdgeProps edgeProps = Soup.CONFIG.getEdgeProps(edgeType);
                        return edgeProps.getDeviceBounds() == TEdgeProps.EDeviceBounds.INDEVICE;
                    } catch (NoSuchEdgeException e) {
                        return false;
                    }
                }
        ).collect(Collectors.toSet());

        return JGraphTHelper.toWeightedGraph(indeviceEdgeSet);
    }
}
