package ru.yandex.crypta.graph.api.service.transformer;

import java.util.Collection;

import org.jgrapht.graph.WeightedMultigraph;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.crypta.graph.api.model.graph.Edge;
import ru.yandex.crypta.graph.api.model.graph.Vertex;
import ru.yandex.crypta.graph.soup.config.Soup;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeProps;
import ru.yandex.crypta.graph.soup.config.proto.TEdgeType;
import ru.yandex.crypta.graph.soup.config.proto.TLogSourceType;
import ru.yandex.crypta.graph.soup.config.proto.TSourceType;
import ru.yandex.crypta.lib.proto.identifiers.TIdType;

public class JGraphTHelper {

    private static final MapF<TEdgeProps.EEdgeStrength, Integer> STRENGTHS = Cf.hashMap();

    static {
        STRENGTHS.put(TEdgeProps.EEdgeStrength.PROBABILISTIC, 0);
        STRENGTHS.put(TEdgeProps.EEdgeStrength.USUAL, 1);
        STRENGTHS.put(TEdgeProps.EEdgeStrength.TRUSTED, 2);
        STRENGTHS.put(TEdgeProps.EEdgeStrength.ARTIFICIAL, 3);
    }

    public static WeightedMultigraph<Vertex, Edge> toWeightedGraph(Collection<Edge> edges) {
        WeightedMultigraph<Vertex, Edge> graph = new WeightedMultigraph<>(Edge.class);

        for (Edge edge : edges) {
            fillGraph(graph, edge);

            double weight = 0.0;
            try {
                weight = getEdgeWeight(edge);
            } catch (Exception ignored) {
                ignored.printStackTrace(System.err);
            }

            graph.setEdgeWeight(edge, weight);
        }
        return graph;
    }

    private static double getEdgeWeight(Edge edge) {
        TEdgeProps edgeProps = getEdgeProps(edge);

        TEdgeProps.EEdgeStrength edgeStrength = edgeProps == null ?
                TEdgeProps.EEdgeStrength.UNKNOWN : edgeProps.getEdgeStrength();
        int edgeStrengthWeight = -STRENGTHS.getOrElse(edgeStrength, 0);

        double weight = edge.getWeight() == null ? 1.0 : edge.getWeight();

        return weight * edgeStrengthWeight;
    }

    public static WeightedMultigraph<Vertex, Edge> toOneVertexGraph(Vertex v) {
        WeightedMultigraph<Vertex, Edge> x = new WeightedMultigraph<>(Edge.class);
        x.addVertex(v);
        return x;
    }

    public static WeightedMultigraph<Vertex, Edge> toSimpleGraph(Collection<Edge> edges) {
        WeightedMultigraph<Vertex, Edge> x = new WeightedMultigraph<>(Edge.class);
        for (Edge edge : edges) {
            fillGraph(x, edge);
        }
        return x;
    }

    private static void fillGraph(WeightedMultigraph<Vertex, Edge> x, Edge edge) {
        Vertex v1 = new Vertex(edge.getId1(), edge.getId1Type());
        Vertex v2 = new Vertex(edge.getId2(), edge.getId2Type());
        x.addVertex(v1);
        x.addVertex(v2);
        x.addEdge(v1, v2, edge);
    }

    private static TEdgeProps getEdgeProps(Edge edge) {
        var instance = Soup.CONFIG;
        TIdType id1Type = instance.getIdType(edge.getId1Type());
        TIdType id2Type = instance.getIdType(edge.getId2Type());
        TSourceType sourceType = instance.getSourceType(edge.getSourceType());
        TLogSourceType logSource = instance.getLogSource(edge.getLogSource());

        TEdgeType edgeType = TEdgeType.newBuilder()
                .setId1Type(id1Type.getType())
                .setId2Type(id2Type.getType())
                .setSourceType(sourceType.getType())
                .setLogSource(logSource.getType())
                .build();

        return instance.getEdgeProps(edgeType);
    }
}
