package ru.yandex.crypta.graph.api.utils;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import ru.yandex.crypta.graph.api.model.graph.Edge;
import ru.yandex.crypta.graph.api.model.graph.Graph;
import ru.yandex.crypta.graph.api.model.graph.GraphComponent;
import ru.yandex.crypta.graph.api.model.graph.Vertex;

public class GraphDiffHelper {

    private GraphDiffHelper() {
    }


    public static Graph getGraphsDiff(Graph graph1, Graph graph2) {
        // edges section
        Set<Edge> graph1Edges = new HashSet<>();
        graph1.getGraphComponents().forEach(component -> graph1Edges.addAll(component.getEdges()));

        Set<Edge> graph2Edges = new HashSet<>();
        graph2.getGraphComponents().forEach(component -> graph2Edges.addAll(component.getEdges()));

        Set<Edge> removedEdges = new HashSet<>(graph1Edges);
        removedEdges.removeAll(graph2Edges);

        Set<Edge> addedEdges = new HashSet<>(graph2Edges);
        addedEdges.removeAll(graph1Edges);

        Set<Edge> notChangedEdges = new HashSet<>(graph1Edges);
        notChangedEdges.retainAll(graph2Edges);

        List<Edge> edges = new ArrayList<>();
        addedEdges.forEach(edge ->
        {
            edge.setAddedStatus();
            edges.add(edge);
        });
        removedEdges.forEach(edge ->
        {
            edge.setRemovedStatus();
            edges.add(edge);
        });
        edges.addAll(notChangedEdges);

        String cryptaId1 = graph1.getGraphComponents().get(0).getCryptaId();
        String cryptaId2 = graph2.getGraphComponents().get(0).getCryptaId();
        String diffId = cryptaId1 + "&" + cryptaId2;

        // vertices section
        Set<Vertex> graph1Verts = new HashSet<>();
        graph1.getGraphComponents().forEach(component -> graph1Verts.addAll(component.getVertices()));

        Set<Vertex> graph2Verts = new HashSet<>();
        graph2.getGraphComponents().forEach(component -> graph2Verts.addAll(component.getVertices()));

        Set<Vertex> removedVerts = new HashSet<>(graph1Verts);
        removedVerts.removeAll(graph2Verts);

        Set<Vertex> addedVerts = new HashSet<>(graph2Verts);
        addedVerts.removeAll(graph1Verts);

        Set<Vertex> notChangedVerts = new HashSet<>(graph1Verts);
        notChangedVerts.retainAll(graph2Verts);

        List<Vertex> verteces = new ArrayList<>();
        addedVerts.forEach(vertex ->
        {
            vertex.setAddedStatus();
            verteces.add(vertex);
        });
        removedVerts.forEach(vertex ->
        {
            vertex.setRemovedStatus();
            verteces.add(vertex);
        });
        verteces.addAll(notChangedVerts);

        // diff making section
        GraphComponent component = new GraphComponent(diffId, verteces, edges);
        List<GraphComponent> components = new ArrayList<GraphComponent>();
        components.add(component);

        return new Graph(components);
    }


}
