#pragma once

#include <library/cpp/bloom_filter/bloomfilter.h>

namespace NCrypta::NEmailsFilter {
    class TEuEmailsFilter {
    public:
        TEuEmailsFilter(size_t elemcount, float error = 0.000001);

        void AddEmail(const TString& email);
        bool IsEuEmail(TStringBuf email) const;
        static bool HasEuTld(TStringBuf email);

        size_t GetBitCount() const;
        size_t GetHashCount() const;

        void Save(IOutputStream* out) const;
        void Load(IInputStream* inp);

    private:
        TBloomFilter BloomFilter;
    };

    TEuEmailsFilter CreateEuEmailsFilter(const TString& fileName);
}
