#include <crypta/graph/bloom_email/lib/eu_emails_filter.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/env.h>

#include <util/generic/hash.h>

using namespace NCrypta::NEmailsFilter;

Y_UNIT_TEST_SUITE(TEuEmailsFilter) {
    Y_UNIT_TEST(TEuEmailsFilter) {
        const TString testDataFile = ArcadiaFromCurrentLocation(__SOURCE_FILE__, "emails_eu_sample.json");

        auto filter = CreateEuEmailsFilter(testDataFile);

        const THashMap<TString, bool> emails{
            {"zzzz@yandex.ru", true},
            {"zzzz@yandex.de", true},
            {"zzz@yandex.ru", false},
            {"zzz@yandex.de", true}};

        for (const auto& [email, isEu] : emails) {
            UNIT_ASSERT_EQUAL(filter.IsEuEmail(email), isEu);
        }
    }
}
