from datetime import timedelta

from crypta.lib.python.spine.consts import environment
from crypta.lib.python.spine.juggler import juggler_check_generator
from crypta.lib.python.spine.yt import yt_config_registry
from crypta.lib.python.spine.yt.yt_latency_metric import YtLatencyMetric


rootPaths = {
    environment.PRODUCTION: "//home/crypta/public",
    environment.TESTING: "//home/crypta/public",
}
udfPath = "udfs/unstable/libeu_email_filter_udf.so"
udfRebuildThreshold = timedelta(hours=60)


def get_registry():
    juggler = juggler_check_generator.JugglerCheckGenerator(
        host="crypta-graph-bloom-email",
        tags=["crypta-graph-bloom_email", "crypta-idfy-telegram-alert"],
    )

    yt_registry = yt_config_registry.YtConfigRegistry(
        juggler,
        rootPaths,
        yt_config_registry.DEFAULT_SOLOMON_PROJECT,
    )

    YtLatencyMetric(yt_registry, udfPath).add_age_alert(
        threshold=udfRebuildThreshold,
    )

    return juggler
