#include <crypta/graph/bloom_email/lib/eu_emails_filter.h>
#include <ydb/library/yql/public/udf/udf_helpers.h>

#include <library/cpp/resource/resource.h>
#include <util/stream/file.h>

using namespace NYql;
using namespace NUdf;

namespace {
    class TIsEuEmail: public TBoxedValue {
    public:
        static const TStringRef& Name() {
            static auto name = TStringRef::Of("IsEuEmail");
            return name;
        }

        static bool DeclareSignature(
            const TStringRef& name,
            TType*,
            IFunctionTypeInfoBuilder& builder,
            bool typesOnly) {
            if (TIsEuEmail::Name() == name) {
                const auto& optionalStringType = builder.Optional()->Item<char*>().Build();
                builder.Args(1)->Add(optionalStringType).Done().Returns<bool>();

                if (!typesOnly) {
                    builder.Implementation(new TIsEuEmail());
                }
                return true;
            } else {
                return false;
            }
        }

        TIsEuEmail()
        : Filter(0)
        {
            TStringStream data(NResource::Find("bloom_eumails.bin"));
            Filter.Load(&data);
        }

    private:
        TUnboxedValue Run(
            const IValueBuilder*,
            const TUnboxedValuePod* args) const override {
            if (!args || !args[0]) {
                    return {};
            }

            return TUnboxedValuePod(Filter.IsEuEmail(args[0].AsStringRef()));
        }

        NCrypta::NEmailsFilter::TEuEmailsFilter Filter;
    };

    class TEuEmailsFilter : public IUdfModule {
    public:
        TStringRef Name() const {
            return TStringRef::Of("EuEmailsFilter");
        }

        void GetAllFunctions(IFunctionsSink& sink) const final {
            sink.Add(TIsEuEmail::Name());
        }

        void BuildFunctionTypeInfo(
            const TStringRef& name,
            TType* userType,
            const TStringRef&,
            ui32 flags,
            IFunctionTypeInfoBuilder& builder) const final {
            try {
                bool typesOnly = (flags & TFlags::TypesOnly);

                if (TIsEuEmail::Name() == name) {
                    TIsEuEmail::DeclareSignature(name, userType, builder, typesOnly);
                }
            } catch (const std::exception& e) {
                builder.SetError(CurrentExceptionMessage());
            }
        }

        void CleanupOnTerminate() const final {}
    };
}

REGISTER_MODULES(TEuEmailsFilter)
