#include <crypta/graph/bloom_email/lib/eu_emails_filter.h>
#include <crypta/graph/bloom_email/proto/builder.pb.h>

#include <crypta/lib/native/cmd_args/parse_pb_options.h>

#include <mapreduce/yt/interface/client.h>
#include <mapreduce/yt/interface/operation.h>
#include <util/stream/file.h>
#include <util/stream/input.h>

using namespace NCrypta::NEmailsFilter;

namespace {
    TEuEmailsFilter ImportFilterFromYt(const NYT::IClientBasePtr& client, const NYT::TYPath& from) {
        TEuEmailsFilter filter{0};
        auto ytFileReader = client->CreateFileReader(from);

        filter.Load(&(*ytFileReader));

        return filter;
    }
}

int main(int argc, const char* argv[]) {
    auto config = NCrypta::ParsePbOptions<TBuilderOptions>(argc, argv);

    Cout << "Config successfully parsed, log initialized." << Endl;

    NYT::Initialize(argc, argv);
    auto client = NYT::CreateClient(config.GetYt().GetProxy());

    Cout << "Reading emails from: " << config.GetEmailsTablePath() << Endl;

    TVector<TString> emails;

    auto reader = client->CreateTableReader<TBuilderEmailEntry>(config.GetEmailsTablePath());
    for (; reader->IsValid(); reader->Next()) {
        auto row = reader->GetRow();

        emails.push_back(std::move(row.GetEmail()));
    }

    Cout << "Table had been read. Total emails read: " << emails.size() << Endl;

    const TEuEmailsFilter& filter = ImportFilterFromYt(client, config.GetFilterOutputPath());

    Cout << "Filter had been loaded from " << config.GetFilterOutputPath()
         << ". Size: " << 1. * filter.GetBitCount() / (8 * 1024) << " Kb." << Endl;

    int64_t failures{0};
    for (const auto& email : emails) {
        if (!filter.IsEuEmail(email)) {
            // Cout << "Email: " << email << " should be marked as EU but it does not." << Endl;
            ++failures;
        };
    }

    Cout << "Total failures: " << failures << "." << Endl;
}
