import argparse
import cProfile
import json

from crypta.graph.bochka.lib import packers


def parse_args():
    parser = argparse.ArgumentParser()
    parser.add_argument("--iterations", default=100, type=int)
    return parser.parse_args()


def main():
    args = parse_args()

    with open("data.json") as f:
        rows = [json.loads(line) for line in f]

    pr = cProfile.Profile()
    pr.enable()

    for i in range(args.iterations):
        packers.tskv_to_json(1500000000, rows[i % len(rows)])

    pr.disable()
    pr.print_stats(sort="tottime")
