import datetime

from crypta.graph.soup.config.python import LOG_SOURCE
from crypta.graph.data_import.stream.lib.tasks.base import StreamBaseYqlTask
import crypta.lib.python.bt.conf.conf as conf


class AccessLogImportTask(StreamBaseYqlTask):

    log_source = LOG_SOURCE.ACCESS_LOG

    def observed_paths(self):
        # Use symlinks made for the daily process for now,
        # and use the shortest available aggregation period
        symlinks = self.yt.list(conf.paths.access_log_symlinks, absolute=True)
        periods = ["stream/5min", "5min", "30min", "1h", "1d"]
        for sl in symlinks:
            real_path = self.yt.get_attribute(sl, "path")
            real_path = real_path.replace("1d", "")
            for p in periods:
                period_path = real_path + p
                if self.yt.exists(period_path):
                    yield period_path
                    break

    @property
    def query_template(self):
        return "access_log.sql.j2"

    @property
    def limit_day(self):
        return datetime.datetime.now() - datetime.timedelta(days=3)
