{% if not is_embedded %}
PRAGMA Library = 'ut_utils_lib.sql';
{% endif %}

IMPORT {% if is_embedded %}.lib.{% endif %}ut_utils_lib SYMBOLS $ua_is_bad;

$log_tables = AsList(
    '{{ input | join("', '") | safe }}'
);

$out_soup = '{{ output }}';
$out_ua = '{{ output_extra_data_dir }}/access_log_ua/{{ uniqid }}';

$yandexuid = IdType::YANDEXUID();
$uuid = IdType::UUID();
$mm_device_id = IdType::MM_DEVICE_ID();

$app_url_redir = SourceType::APP_URL_REDIR();
$access_yp_cookie = SourceType::ACCESS_YP_COOKIE();
$app_url_redir_desktop = SourceType::APP_URL_REDIR_DESKTOP();

$access_log = LogSource::ACCESS_LOG();

$log_path = Re2::Capture(@@.*/logs/(?P<name>[^/]+)/.*@@);
$device_id_re = Re2::Capture('(^|.*[^a-zA-Z_-])did\\.([a-zA-Z0-9-]*).*');
$uuid_re = Re2::Capture('(^|.*[^a-zA-Z_-])uuid\\.([a-zA-Z0-9]{32}).*');

$extract_cookies = ($str, $keys) -> {
    $parts = String::SplitToList($str, '; ');
    $pairs = ListMap($parts, ($x) -> {
        $p = String::SplitToList($x, '=', 1 as Limit);
        return AsTuple($p[0], $p[1]);
    });

    $key_pairs = ListMap($keys, ($k) -> {
        $filtered = ListFilter($pairs, ($x) -> { return $x.0 == $k; });
        $vals = ListMap($filtered, ($x) -> { return $x.1 ?? ""; });
        return AsTuple($k, $vals)
    });

    return ToDict($key_pairs);
};

$extract = ($values, $re) -> {
    $appre = ListMap($values, ($x) -> { return $re($x)._2 });
    $nonnull = ListFilter($appre, ($x) -> { return $x is not null; });
    return if(ListLength($nonnull) > 0, unwrap($nonnull[0]), null);
};

$extracted_cookies = (
    SELECT
        $log_path(TablePath()).name AS log_name,
        String::SplitToList(iso_eventtime, ' ')[0] as dt,
        (yandexuid ?? raw_yandexuid) as yandexuid_field,
        user_agent,
        $extract_cookies(cookies, AsList('yandexuid', 'ys', 'yp')) as cookies,
        request
    FROM EACH($log_tables)
    WITH SCHEMA Struct<
        iso_eventtime:String?,
        cookies:String?,
        user_agent:String?,
        request:String?,
        yandexuid:String?,
        raw_yandexuid:String?,
    >
    WHERE NOT $ua_is_bad(user_agent, UserAgent::Parse(user_agent))
);

$ids = (
    SELECT
        log_name,
        dt,
        yandexuid_field,
        (cookies['yandexuid'] ?? ListCreate(OptionalType(DataType("String"))))[0] as yandexuid_cookies,
        $extract(cookies['yp'], $device_id_re) as mm_device_id_yp,
        $extract(cookies['ys'], $device_id_re) as mm_device_id_ys,
        Url::GetCGIParam('http://dummy.ru' || request, 'uuid') as uuid_request,
        $extract(cookies['yp'], $uuid_re) as uuid_yp,
        $extract(cookies['ys'], $uuid_re) as uuid_ys,
        UserAgent::Parse(user_agent).isMobile as is_mobile,
        UserAgent::Parse(user_agent).OSFamily as os,
        UserAgent::Parse(user_agent).BrowserName as browser_name,
        user_agent
    FROM $extracted_cookies
);

$ids2 = (
    SELECT *
    FROM (
        SELECT
            t.yandexuid_field AS yandexuid,
            t.*
        WITHOUT
            t.yandexuid_field,
            t.yandexuid_cookies
        FROM $ids AS t
        WHERE
            t.yandexuid_field IS NOT NULL
            AND (
                t.yandexuid_cookies IS NULL
                OR (t.yandexuid_field == t.yandexuid_cookies)
            )

        UNION ALL

        SELECT
            t.yandexuid_cookies AS yandexuid,
            t.*
        WITHOUT t.yandexuid_field, t.yandexuid_cookies
        FROM $ids AS t
        WHERE
            t.yandexuid_cookies IS NOT NULL
            AND (
                t.yandexuid_field IS NULL
                OR (t.yandexuid_field != t.yandexuid_cookies)
            )
    ) WHERE Identifiers::IsValidYandexuid(yandexuid)
);

$ids3 = (
    select distinct
        dt,
        yandexuid,
        mm_device_id_yp,
        mm_device_id_ys,
        uuid_request,
        uuid_yp,
        uuid_ys,
        is_mobile
    from $ids2
    where yandexuid is not null and (
        mm_device_id_yp is not null or
        mm_device_id_ys is not null or
        uuid_request is not null or
        uuid_yp is not null or
        uuid_ys is not null
    )
);

$edges = (
    select
        yandexuid as id1,
        $yandexuid as id1Type,
        uuid_yp ?? uuid_ys as id2,
        $uuid as id2Type,
        $access_yp_cookie as sourceType,
        $access_log as logSource,
        dt
    from $ids3
    where uuid_yp is not null or uuid_ys is not null

    union all

    select
        yandexuid as id1,
        $yandexuid as id1Type,
        uuid_request as id2,
        $uuid as id2Type,
        if(is_mobile, $app_url_redir, $app_url_redir_desktop) as sourceType,
        $access_log as logSource,
        dt
    from $ids3
    where uuid_yp is null and uuid_ys is null and uuid_request is not null

    union all

    select
        yandexuid as id1,
        $yandexuid as id1Type,
        mm_device_id_yp ?? mm_device_id_ys as id2,
        $mm_device_id as id2Type,
        $access_yp_cookie as sourceType,
        $access_log as logSource,
        dt
    from $ids3
    where mm_device_id_yp is not null or mm_device_id_ys is not null
);

$uniq_edges = (
    select unwrap(id1) as id1, id1Type, unwrap(id2) as id2, id2Type, sourceType, logSource, AGGREGATE_LIST_DISTINCT(dt) as dates
    from $edges
    group by id1, id1Type, id2, id2Type, sourceType, logSource
);

INSERT INTO $out_soup WITH TRUNCATE
SELECT * FROM $uniq_edges;

INSERT INTO $out_ua WITH TRUNCATE
SELECT DISTINCT
    yandexuid,
    user_agent,
    os,
    dt
FROM (
    SELECT
        unwrap(yandexuid) AS yandexuid,
        user_agent,
        os,
        dt
    FROM $ids2
    WHERE
        NOT (
            -- CRYPTR-1683 Skip samsung internet from morda, bad oneday cookies
            (log_name == "morda-access-log")
            AND (browser_name == "Samsung Internet")
        )
);
