from __future__ import print_function

from crypta.lib.python.yql_runner.base_parser import BaseParser


class MetricaMonthAggregator(BaseParser):

    """ Aggregate metrica month """

    QUERY_TEMPLATE = "metrica_month.sql.j2"

    def __init__(self, date_start, date_end, is_month=True, **kwargs):
        super(MetricaMonthAggregator, self).__init__(date=date_end, **kwargs)
        self.date_start = date_start
        self.date_end = date_end
        self.is_month = is_month

    def get_context_data(self, **kwargs):
        context = super(MetricaMonthAggregator, self).get_context_data(**kwargs)
        context.update(date_start=self.date_start, date_end=self.date_end, is_month=self.is_month)
        return context
