from crypta.lib.python.yql_runner.base_parser import BaseParser


class AutoRuParser(BaseParser):
    QUERY_TEMPLATE = "query.sql.j2"

    def __init__(
        self,
        logfeller_logs,
        warehouse_logs,
        autoid_mm_device_id,
        autoid_yandexuid,
        autoid_phone,
        autoid_gaid,
        autoid_idfa,
        gaid_mm_device_id,
        idfa_mm_device_id,
        *args,
        **kwargs
    ):

        self.logfeller_logs = logfeller_logs
        self.warehouse_logs = warehouse_logs
        self.autoid_mm_device_id = autoid_mm_device_id
        self.autoid_yandexuid = autoid_yandexuid
        self.autoid_phone = autoid_phone
        self.autoid_gaid = autoid_gaid
        self.autoid_idfa = autoid_idfa
        self.gaid_mm_device_id = gaid_mm_device_id
        self.idfa_mm_device_id = idfa_mm_device_id

        super(AutoRuParser, self).__init__(*args, **kwargs)

    def get_context_data(self, **kwargs):
        return super(AutoRuParser, self).get_context_data(
            logfeller_logs=self.logfeller_logs,
            warehouse_logs=self.warehouse_logs,
            autoid_mm_device_id=self.autoid_mm_device_id,
            autoid_yandexuid=self.autoid_yandexuid,
            autoid_phone=self.autoid_phone,
            autoid_gaid=self.autoid_gaid,
            autoid_idfa=self.autoid_idfa,
            gaid_mm_device_id=self.gaid_mm_device_id,
            idfa_mm_device_id=self.idfa_mm_device_id,
            **kwargs
        )
