PRAGMA yson.DisableStrict;
{% if not is_embedded %}
PRAGMA Library = 'aggregation_lib.sql';
{% endif %}

IMPORT {% if is_embedded %}.lib.{% endif %}aggregation_lib SYMBOLS $aggregate_uniq_arrays;

$date = "{{ date }}";

$auth_id = ($user) -> {
    RETURN Yson::ConvertToString(Yson::YPath(Yson::Parse($user), "/authorisation/user/id"));
};

$upd_id = ($user) -> {
    RETURN Yson::ConvertToString(Yson::YPath(Yson::Parse($user), "/update/user/id"));
};

$context_id = ($context) -> {
    RETURN Yson::ConvertToString(Yson::YPath(Yson::Parse($context), "/userId"));
};

$auth_phones = ($user) -> {
    RETURN Yson::ConvertToStringList(Yson::YPath(Yson::Parse($user), "/authorisation/user/phones"));
};

$upd_phones = ($user) -> {
    RETURN Yson::ConvertToStringList(Yson::YPath(Yson::Parse($user), "/update/user/phones"));
};

$offer_create_phone = ($offer) -> {
    RETURN Yson::ConvertTo(
        Yson::YPath(Yson::Parse($offer), "/create/offer/auto/seller/phones"),
        ParseType("List<Dict<String,String>>?")
    );
};

$offer_update_phone = ($offer) -> {
    RETURN Yson::ConvertTo(
        Yson::YPath(Yson::Parse($offer), "/update/offer/auto/seller/phones"),
        ParseType("List<Dict<String,String>>?")
    );
};


DEFINE ACTION $update_auto_logfeller_logs($logs) AS
    $row_fields =
    SELECT
        _rest["userEvent"] as user,
        _rest["requestContext"] as context,
        _rest["offerEvent"] AS offer
    FROM $logs
    WHERE environment = "STABLE"
    AND domain = "DOMAIN_AUTO"
    AND (_rest["userEvent"] IS NOT NULL OR _rest["offerEvent"] IS NOT NULL)
    AND Yson::ConvertToString(Yson::YPath(_rest["requestContext"], "/application")) IN ("android", "ios", "frontend");

    $parsed_fields =
    SELECT
        CASE
            WHEN $auth_id(user) IS NOT NULL THEN $auth_id(user)
            WHEN $upd_id(user) IS NOT NULL THEN $upd_id(user)
            ELSE $context_id(context)
        END AS auto_id,
        CASE
            WHEN $auth_id(user) IS NOT NULL THEN $auth_phones(user)
            WHEN $upd_id(user) IS NOT NULL THEN $upd_phones(user)
            WHEN $offer_update_phone(offer) IS NOT NULL THEN
                ListFlatMap(
                    $offer_update_phone(offer),
                    ($item) -> {
                        RETURN $item["original"];
                    }
                )
            ELSE ListFlatMap(
                $offer_create_phone(offer),
                ($item) -> {
                    RETURN $item["original"];
                }
            )
        END AS phones,
        Yson::ConvertToString(Yson::YPath(Yson::Parse(context), "/metricaDeviceId")) AS metricaDeviceId,
        Yson::ConvertToString(Yson::YPath(Yson::Parse(context), "/yandexUid")) AS yandexUid
    FROM $row_fields
    WHERE $auth_id(user) IS NOT NULL
        OR $upd_id(user) IS NOT NULL
        OR $context_id(context) IS NOT NULL;

    INSERT INTO @auto_logfeller_logs
    SELECT
        auto_id,
        metricaDeviceId,
        yandexUid,
        AGGREGATE_BY(phones ?? [], $aggregate_uniq_arrays) ?? [] AS phones
    FROM $parsed_fields
    GROUP BY (auto_id, metricaDeviceId, yandexUid);

END DEFINE;


DEFINE ACTION $update_auto_warehouse_logs($logs) AS

    INSERT INTO @auto_warehouse_logs
    SELECT DISTINCT
        user_info.user_id as auto_id,
        user_info.app_user_info.mobile_uuid as metricaDeviceId,
        user_info.web_user_info.user_yandexuid as yandexUid,
        user_info.app_user_info.gaid as gaid,
        user_info.app_user_info.idfa as idfa,
    FROM $logs;

END DEFINE;


DEFINE ACTION $prepare_useful_fields() AS

    INSERT INTO @useful_fields
    SELECT
        auto_id,
        yandexUid,
        metricaDeviceId,
        phones,
        gaid,
        idfa,
    FROM CONCAT(@auto_logfeller_logs,@auto_warehouse_logs);

END DEFINE;


DEFINE ACTION $make_edges($autoid_mm_device_id, $autoid_yandexuid, $autoid_phone,
                          $autoid_gaid, $autoid_idfa, $gaid_mm_device_id, $idfa_mm_device_id) AS

    INSERT INTO $autoid_mm_device_id WITH TRUNCATE
    SELECT DISTINCT
        Identifiers::NormalizeAutoId(auto_id) AS id1,
        IdType::AUTO_ID() AS id1Type,
        Identifiers::NormalizeMmDeviceId(metricaDeviceId) AS id2,
        IdType::MM_DEVICE_ID() AS id2Type,
        $date AS `date`,
        SourceType::AUTORU_EVENT_LOG() AS sourceType,
        LogSource::AUTORU() AS logSource,
        1 AS dayHits,
        Null AS dayActivity
    FROM @useful_fields
    WHERE Identifiers::IsValidAutoId(auto_id) AND Identifiers::IsValidMmDeviceId(metricaDeviceId);

    INSERT INTO $autoid_yandexuid WITH TRUNCATE
    SELECT DISTINCT
        Identifiers::NormalizeAutoId(auto_id) AS id1,
        IdType::AUTO_ID() AS id1Type,
        Identifiers::NormalizeYandexuid(yandexUid) AS id2,
        IdType::YANDEXUID() AS id2Type,
        $date AS `date`,
        SourceType::AUTORU_EVENT_LOG() AS sourceType,
        LogSource::AUTORU() AS logSource,
        1 AS dayHits,
        Null AS dayActivity
    FROM @useful_fields
    WHERE Identifiers::IsValidAutoId(auto_id) AND Identifiers::IsValidYandexuid(yandexUid);

    INSERT INTO $autoid_phone WITH TRUNCATE
    SELECT DISTINCT
        Identifiers::NormalizeAutoId(auto_id) AS id1,
        IdType::AUTO_ID() AS id1Type,
        Identifiers::NormalizePhone(phones) AS id2,
        IdType::PHONE() AS id2Type,
        $date AS `date`,
        SourceType::AUTORU_EVENT_LOG() AS sourceType,
        LogSource::AUTORU() AS logSource,
        1 AS dayHits,
        Null AS dayActivity
    FROM (
        SELECT
            auto_id,
            phones
        FROM (
            SELECT auto_id, phones
            FROM @useful_fields
            WHERE Identifiers::IsValidAutoId(auto_id) AND phones IS NOT NULL
        )
        FLATTEN LIST BY phones
    )
    WHERE Identifiers::IsValidPhone(phones);

    INSERT INTO $autoid_gaid WITH TRUNCATE
    SELECT DISTINCT
        Identifiers::NormalizeAutoId(auto_id) AS id1,
        IdType::AUTO_ID() AS id1Type,
        Identifiers::NormalizeGaid(gaid) AS id2,
        IdType::GAID() AS id2Type,
        $date AS `date`,
        SourceType::AUTORU_EVENT_LOG() AS sourceType,
        LogSource::AUTORU() AS logSource,
        1 AS dayHits,
        Null AS dayActivity
    FROM @useful_fields
    WHERE Identifiers::IsValidAutoId(auto_id) AND Identifiers::IsValidGaid(gaid);

    INSERT INTO $autoid_idfa WITH TRUNCATE
    SELECT DISTINCT
        Identifiers::NormalizeAutoId(auto_id) AS id1,
        IdType::AUTO_ID() AS id1Type,
        Identifiers::NormalizeIdfa(idfa) AS id2,
        IdType::IDFA() AS id2Type,
        $date AS `date`,
        SourceType::AUTORU_EVENT_LOG() AS sourceType,
        LogSource::AUTORU() AS logSource,
        1 AS dayHits,
        Null AS dayActivity
    FROM @useful_fields
    WHERE Identifiers::IsValidAutoId(auto_id) AND Identifiers::IsValidIdfa(idfa);

    INSERT INTO $gaid_mm_device_id WITH TRUNCATE
    SELECT DISTINCT
        Identifiers::NormalizeGaid(gaid) AS id1,
        IdType::GAID() AS id1Type,
        Identifiers::NormalizeMmDeviceId(metricaDeviceId) AS id2,
        IdType::MM_DEVICE_ID() AS id2Type,
        $date AS `date`,
        SourceType::AUTORU_EVENT_LOG() AS sourceType,
        LogSource::AUTORU() AS logSource,
        1 AS dayHits,
        Null AS dayActivity
    FROM @useful_fields
    WHERE Identifiers::IsValidMmDeviceId(metricaDeviceId) AND Identifiers::IsValidGaid(gaid);

    INSERT INTO $idfa_mm_device_id WITH TRUNCATE
    SELECT DISTINCT
        Identifiers::NormalizeIdfa(idfa) AS id1,
        IdType::IDFA() AS id1Type,
        Identifiers::NormalizeMmDeviceId(metricaDeviceId) AS id2,
        IdType::MM_DEVICE_ID() AS id2Type,
        $date AS `date`,
        SourceType::AUTORU_EVENT_LOG() AS sourceType,
        LogSource::AUTORU() AS logSource,
        1 AS dayHits,
        Null AS dayActivity
    FROM @useful_fields
    WHERE Identifiers::IsValidMmDeviceId(metricaDeviceId) AND Identifiers::IsValidIdfa(idfa);

END DEFINE;

-- ========================================================================= --

$logfeller_logs = "{{ logfeller_logs }}";
$warehouse_logs = "{{ warehouse_logs }}";
$autoid_mm_device_id = "{{ autoid_mm_device_id }}";
$autoid_yandexuid = "{{ autoid_yandexuid }}";
$autoid_phone = "{{ autoid_phone }}";
$autoid_gaid = "{{ autoid_gaid }}";
$autoid_idfa = "{{ autoid_idfa }}";
$gaid_mm_device_id = "{{ gaid_mm_device_id }}";
$idfa_mm_device_id = "{{ idfa_mm_device_id }}";

DO $update_auto_logfeller_logs($logfeller_logs);
DO $update_auto_warehouse_logs($warehouse_logs);
COMMIT;
DO $prepare_useful_fields();
COMMIT;
DO $make_edges($autoid_mm_device_id, $autoid_yandexuid, $autoid_phone, $autoid_gaid, $autoid_idfa, $gaid_mm_device_id, $idfa_mm_device_id);
