{% if not is_embedded %}
PRAGMA Library = 'sn_id_parse_lib.sql';
{% endif %}

{% if stream %}
$barnavig_log = AsList(
    '{{ input | join("', '") | safe }}'
);
$barlog_soup = '{{ output }}';
{% endif %}
$tmp_source_path = '{{ tmp_source_path }}';

IMPORT {% if is_embedded %}.lib.{% endif %}sn_id_parse_lib SYMBOLS
    $fp_parse_vk_id_from_http_params,
    $fp_parse_ok_id_from_http_params
;

-- ========================================================================= --

$date = '{{ date }}';

$barnavig_query = (
    SELECT
        _logfeller_timestamp AS ts,
        String::SplitToList(iso_eventtime, ' ')[0] as dt,
        Identifiers::NormalizeVkId($fp_parse_vk_id_from_http_params(http_params)) AS vk_com_id,
        Identifiers::NormalizeOkId($fp_parse_ok_id_from_http_params(http_params)) AS ok_ru_id,
        Identifiers::NormalizeYandexuid(yandexuid) AS yuid,
    FROM EACH($barnavig_log)
);

$pre_soup = (
    SELECT
        id1,
        id2,
        id1Type,
        id2Type,
        sourceType,
        logSource,
        AGGREGATE_LIST_DISTINCT(dt) as dates
    FROM (
        SELECT
            yuid AS id1,
            vk_com_id AS id2,
            IdType::YANDEXUID() AS id1Type,
            IdType::VK_ID() AS id2Type,
            SourceType::VK_APPS_REDIR() AS sourceType,
            LogSource::BAR_NAVIG_LOG() AS logSource,
            dt
        FROM $barnavig_query

        UNION ALL

        SELECT
            yuid AS id1,
            ok_ru_id AS id2,
            IdType::YANDEXUID() AS id1Type,
            IdType::OK_ID() AS id2Type,
            SourceType::OK_APPS_REDIR() AS sourceType,
            LogSource::BAR_NAVIG_LOG() AS logSource,
            dt
        FROM $barnavig_query
    ) WHERE id1 IS NOT NULL
        AND id2 IS NOT NULL
    GROUP BY id1, id2, id1Type, id2Type, sourceType, logSource
);

INSERT INTO $barlog_soup WITH TRUNCATE
SELECT * FROM $pre_soup
UNION ALL SELECT * FROM $tmp_source_path
WITH SCHEMA Struct<
    `id1`: String?,
    `id1Type`: String?,
    `id2`: String?,
    `id2Type`: String?,
    `sourceType`: String?,
    `logSource`: String?,
    `dates`: List<String>?,
>
;
