from __future__ import print_function
import os

from crypta.lib.python.yql_runner.base_parser import BaseParser


class CheventParser(BaseParser):

    """ Parse chevent log """

    # input directories
    CHEVENT_LOG_DIR = "//logs/bs-chevent-log/1d"
    QUERY_TEMPLATE = "chevent.sql.j2"

    def get_dirs(self):
        """ Get current environ and replace directories path to env """
        dirs = super(CheventParser, self).get_dirs()
        chevent_log_dir = os.environ.get(
            "LOGFELLER_BS_CHEVENT_LOG_FOLDER", self.CHEVENT_LOG_DIR.format(crypta_env=self.crypta_env)
        ).rstrip("/")
        dirs.update(chevent_log_dir=chevent_log_dir)
        return dirs
