{% if not is_embedded %}
PRAGMA Library = 'metrica_lib.sql';
{% endif %}

IMPORT {% if is_embedded %}.lib.{% endif %}metrica_lib SYMBOLS
    $force_null
;

$date = '{{ date }}';
$date_format = DateTime::Format("%Y-%m-%d");

$chevent_log = '{{ chevent_log_dir }}/{{ date }}';

$yt_output_folder = '{{ graph_output_dir }}';
$out_soup_folder = '{{ graph_output_dir }}/v2/soup/day/{{ date }}/';

$chevent_fields = (
    SELECT * FROM (
        SELECT
            $date_format(DateTime::FromSeconds(
                CAST(_logfeller_timestamp AS UInt32) ?? 0
            )) AS dt,
            $force_null(oaid) AS oaid,
            $force_null(gaid) AS gaid,
            $force_null(idfa) AS idfa,
            $force_null(ifv) AS ifv,
            $force_null(rawuniqid) AS yandexuid,
            $force_null(cryptaid) AS crypta_id,
            $force_null(cryptaidv2) AS crypta_id_v2
        FROM $chevent_log
        WHERE impressionoptions NOT LIKE '%in-device-%'  -- BSSERVER-15417
    ) WHERE True
        -- https://st.yandex-team.ru/CRYPTR-1642#5d94c4924b92d7001dc8d912
        AND yandexuid IS NOT NULL
        AND crypta_id IS NULL
);

$oaid_soup = (
    SELECT
        id1,
        IdType::YANDEXUID() AS id1Type,
        id2,
        IdType::OAID() AS id2Type,
        SourceType::APP_ADV() AS sourceType,
        LogSource::EVENT_LOG() AS logSource,
        AGGREGATE_LIST_DISTINCT(dt) AS dates
    FROM $chevent_fields
    WHERE oaid IS NOT NULL
    GROUP BY
        yandexuid AS id1,
        oaid AS id2
);

$gaid_soup = (
    SELECT
        id1,
        IdType::YANDEXUID() AS id1Type,
        id2,
        IdType::GAID() AS id2Type,
        SourceType::APP_ADV() AS sourceType,
        LogSource::EVENT_LOG() AS logSource,
        AGGREGATE_LIST_DISTINCT(dt) AS dates
    FROM $chevent_fields
    WHERE gaid IS NOT NULL
    GROUP BY
        yandexuid AS id1,
        gaid AS id2
);

$idfa_soup = (
    SELECT
        id1,
        IdType::YANDEXUID() AS id1Type,
        id2,
        IdType::IDFA() AS id2Type,
        SourceType::APP_ADV() AS sourceType,
        LogSource::EVENT_LOG() AS logSource,
        AGGREGATE_LIST_DISTINCT(dt) AS dates
    FROM $chevent_fields
    WHERE idfa IS NOT NULL
    GROUP BY
        yandexuid AS id1,
        idfa AS id2
);

$ifv_soup = (
    SELECT
        id1,
        IdType::YANDEXUID() AS id1Type,
        id2,
        IdType::IFV() AS id2Type,
        SourceType::APP_ADV() AS sourceType,
        LogSource::EVENT_LOG() AS logSource,
        AGGREGATE_LIST_DISTINCT(dt) AS dates
    FROM $chevent_fields
    WHERE ifv IS NOT NULL
        AND idfa IS NULL
    GROUP BY
        yandexuid AS id1,
        ifv AS id2
);

{% for id_type in ('idfa', 'oaid', 'gaid', 'ifv', ) %}
${{ id_type }}_table = $out_soup_folder || String::JoinFromList(AsList(
    IdType::YANDEXUID(),
    IdType::{{ id_type|upper }}(),
    SourceType::APP_ADV(),
    LogSource::EVENT_LOG()
), "_");

INSERT INTO ${{ id_type }}_table WITH TRUNCATE
SELECT * FROM ${{ id_type }}_soup;
{% endfor %}
