from __future__ import print_function
import os

from crypta.lib.python.yql_runner.base_parser import timer, make_arg_parser
from crypta.graph.data_import.fp_parser.lib import FingerPrintParser


@timer
def main():
    parser = make_arg_parser(description="Parse fp sources logs.")
    args = parser.parse_args()

    fp_parser = FingerPrintParser(
        date=args.date,
        yt_proxy=args.cluster,
        pool=args.pool,
        mrjob_binary=os.path.abspath(args.mrjob),
        udf_resolver_binary=os.path.abspath(args.udfr),
        udfs_dir=os.path.abspath(args.udfsdir),
        loglevel=args.loglevel,
        limit=args.limit,
        is_embedded=args.is_embedded,
    )
    assert fp_parser.get_token(), "Env variable YT_TOKEN required!"
    if os.environ.get("VERBOSE"):
        print(fp_parser.render_query())
    return fp_parser.run()


if __name__ == "__main__":
    main()
