from __future__ import print_function
import os

from crypta.lib.python.yql_runner.base_parser import BaseParser


class FingerPrintParser(BaseParser):

    """ Run YQL query to parse fp sources """

    # input directories
    BSWATCH_LOG_DIR = "//home/logfeller/logs/bs-watch-log/1d"
    PASSPORT_LOG_DIR = "//home/logfeller/logs/passport-log/1d"
    BARNAVIG_LOG_DIR = "//home/logfeller/logs/bar-navig-log/1d"
    REQANS_LOG_DIR = "//home/logfeller/logs/search-proto-reqans-log/1d"
    REQANS_ALICE_LOG_DIR = "//home/logfeller/logs/search-report-alice-log/1d"

    QUERY_TEMPLATE = "fp.sql.j2"

    def get_dirs(self):
        """ Get current environ and replace directories path to env """
        dirs = super(FingerPrintParser, self).get_dirs()
        env = os.getenv
        dirs.update(
            bswatch_log_dir=(env("LOGFELLER_BS_WATCH_FOLDER") or self.BSWATCH_LOG_DIR).rstrip("/"),
            passport_log_dir=(env("LOGFELLER_PASSPORT_FOLDER") or self.PASSPORT_LOG_DIR).rstrip("/"),
            barnavig_log_dir=(env("LOGFELLER_BAR_LOG_FOLDER") or self.BARNAVIG_LOG_DIR).rstrip("/"),
            reqans_log_dir=(env("LOGFELLER_REQANS_NEW_FOLDER") or self.REQANS_LOG_DIR).rstrip("/"),
            reqans_alice_log_dir=(env("LOGFELLER_REQANS_ALICE_FOLDER") or self.REQANS_ALICE_LOG_DIR).rstrip("/"),
        )
        return dirs
