{% if udf_url_enable|default(True) and not (is_embedded or is_local) %}
PRAGMA File('libcrypta_ipreq_udf.so', 'yt://hahn/home/crypta/public/udfs/stable/libcrypta_ipreq_udf.so');
PRAGMA Udf('libcrypta_ipreq_udf.so');
{% endif %}

PRAGMA yson.DisableStrict;
{% if not is_embedded %}
PRAGMA Library = 'aggregation_lib.sql';
PRAGMA Library = 'metrica_lib.sql';
PRAGMA Library = 'sn_id_parse_lib.sql';
PRAGMA Library = 'ut_utils_lib.sql';
{% endif %}

IMPORT {% if is_embedded %}.lib.{% endif %}aggregation_lib SYMBOLS
    $aggregate_sum_dict,
    $dump_as_dict_int
;

IMPORT {% if is_embedded %}.lib.{% endif %}metrica_lib SYMBOLS
    $fp_capture_login,
    $clean_ip,
    $force_null,
    $max_int,
    $dict_join,
    $lower_strip,
    $get_main_regions
;

IMPORT {% if is_embedded %}.lib.{% endif %}sn_id_parse_lib SYMBOLS
    $fp_parse_vk_id_from_url,
    $fp_parse_ok_id_from_url,
    $fp_parse_vk_id_from_http_params,
    $fp_parse_ok_id_from_http_params
;

IMPORT {% if is_embedded %}.lib.{% endif %}ut_utils_lib SYMBOLS $ua_profile_str, $ua_is_bad;

-- ========================================================================= --

$date = '{{ date }}';

-- input tables
{% if crypta_env == 'testing' and SKIP_INPUT_DATA %}
$bswatch_log    = SELECT * FROM `{{ bswatch_log_dir }}/{{ date }}`  TABLESAMPLE SYSTEM(10.0);
$passport_log   = SELECT * FROM `{{ passport_log_dir }}/{{ date }}` TABLESAMPLE SYSTEM(10.0);
$barnavig_log   = SELECT * FROM `{{ barnavig_log_dir }}/{{ date }}` TABLESAMPLE SYSTEM(10.0);
$reqans_log     = SELECT * FROM `{{ reqans_log_dir }}/{{ date }}`   TABLESAMPLE SYSTEM(10.0);
{% else %}
$bswatch_log    = SELECT * FROM `{{ bswatch_log_dir }}/{{ date }}`;
$passport_log   = SELECT * FROM `{{ passport_log_dir }}/{{ date }}`;
$barnavig_log   = SELECT * FROM `{{ barnavig_log_dir }}/{{ date }}`;
$reqans_log     = SELECT * FROM CONCAT(
    `{{ reqans_log_dir }}/{{ date }}`,
    `{{ reqans_alice_log_dir }}/{{ date }}`
);
{% endif %}

$yuids_ua_day_table         = '{{ graph_output_dir }}/{{ date }}/yuids_ua_day';
$yuids_desk_day_table       = '{{ graph_output_dir }}/{{ date }}/yuids_desk_day';
$yuids_mob_day_table        = '{{ graph_output_dir }}/{{ date }}/yuids_mob_day';

$yuid_with_login_fp_table   = '{{ graph_output_dir }}/{{ date }}/yuid_raw/yuid_with_login_fp';
$yuid_with_puid_fp_table    = '{{ graph_output_dir }}/{{ date }}/yuid_raw/yuid_with_puid_fp';
$yuid_with_vk_fp_table      = '{{ graph_output_dir }}/{{ date }}/yuid_raw/yuid_with_vk_fp';
$yuid_with_ok_fp_table      = '{{ graph_output_dir }}/{{ date }}/yuid_raw/yuid_with_ok_fp';
$yuid_with_info_table       = '{{ graph_output_dir }}/{{ date }}/yuid_raw/yuid_with_info';

$yuids_rus_ip_day_table     = '{{ graph_output_dir }}/{{ date }}/yuids_rus_ip_day';

-- ========================================================================= --

$bswatch_query = (
    SELECT
        $clean_ip(clientip) AS ip,
        $fp_capture_login(headerargs).g AS login,
        $force_null(useragent) AS user_agent,
        WeakField(_logfeller_timestamp, 'UInt64') AS ts,
        $force_null(xwapprofile) ?? $force_null(wapprofile) AS wapprofile,
        $force_null(
            $fp_parse_vk_id_from_url(referer)
            ?? $fp_parse_vk_id_from_url(url)
        ) AS vk_com_id,
        $force_null(
            $fp_parse_ok_id_from_url(referer)
            ?? $fp_parse_ok_id_from_url(url)
        ) AS ok_ru_id,
        $force_null(passportuid) AS puid,
        Identifiers::NormalizeYandexuid(uniqid) AS yuid,
        CAST($force_null(regionid) as Int32) as region_id,
        'm' AS source
    FROM $bswatch_log
    WHERE browserinfo NOT REGEXP @@(^|\:)cy\:2($|\:)@@  -- CRYPTR-1978
);

$passport_query = (
    SELECT
        $clean_ip(ip) AS ip,
        $force_null(WeakField(login, 'String')) AS login,
        $force_null(WeakField(user_agent, 'String')) AS user_agent,
        WeakField(_logfeller_timestamp, 'UInt64') AS ts,
        null AS wapprofile,
        null AS vk_com_id,
        null AS ok_ru_id,
        $force_null(WeakField(uid, 'String')) AS puid,
        Identifiers::NormalizeYandexuid(WeakField(yandexuid, 'String')) AS yuid,
        null as region_id,
        'p' AS source
    FROM $passport_log
    WHERE `action` == "cookie_set"
);

$barnavig_query = (
    SELECT
        $clean_ip(ip) AS ip,
        null AS login,
        $force_null(String::ReplaceAll(WeakField(user_agent, 'String'), '\t', ' ')) AS user_agent,
        WeakField(_logfeller_timestamp, 'UInt64') AS ts,
        null AS wapprofile,
        $force_null($fp_parse_vk_id_from_http_params(http_params)) AS vk_com_id,
        $force_null($fp_parse_ok_id_from_http_params(http_params)) AS ok_ru_id,
        null AS puid,
        Identifiers::NormalizeYandexuid(WeakField(yandexuid, 'String')) AS yuid,
        null as region_id,
        'b' AS source
    FROM $barnavig_log
);

$reqans_query = (
    SELECT
        $clean_ip(IpReq::ToString(UserIp)) AS ip,
        UserId.YandexLogin AS login,
        UserAgentRaw AS user_agent,
        _logfeller_timestamp AS ts,
        null AS wapprofile,
        null AS vk_com_id,
        null AS ok_ru_id,
        UserId.PassportUid AS puid,
        Identifiers::NormalizeYandexuid(UserId.YandexUid) AS yuid,
        CAST(UserRegionId as Int32) as region_id,
        'r' AS source
    FROM $reqans_log
);


$fp_source =  (
    SELECT
        yuid,
        ts,
        ip,
        source,

        login,
        puid,
        vk_com_id,
        ok_ru_id,

        -- geo regions
        Geo::RegionByIp(ip).id AS ip_region_id,
        region_id as log_region_id,

        -- ua
        user_agent,
        wapprofile,
        $lower_strip(
            UserAgent::Parse(user_agent).BrowserName
        ) AS browser,
        UserAgent::Parse(user_agent).BrowserVersion ?? '' AS browser_version,
        UserAgent::Parse(user_agent).inAppBrowser as webview,
        $ua_profile_str(UserAgent::Parse(user_agent)) AS ua_profile
    FROM (
        SELECT * FROM $bswatch_query UNION ALL
        SELECT * FROM $passport_query UNION ALL
        SELECT * FROM $barnavig_query UNION ALL
        SELECT * FROM $reqans_query
    ) WHERE yuid IS NOT Null
        AND NOT $ua_is_bad(user_agent, UserAgent::Parse(user_agent))
);

{% include '/templates/soup.sql.j2' %}
{% include '/templates/yuid_info.sql.j2' %}
