-- ========================================================================= --
-- Fill soup tables

-- output tables
DEFINE ACTION $make_fp_soup($log_source, $condition, $suff) AS
$fp_soup_table = '{{ graph_output_dir }}/v2/soup/day/tmp/{{ date }}/' || $suff;

INSERT INTO $fp_soup_table WITH TRUNCATE
SELECT
    id1,
    id2,
    id1Type,
    id2Type,
    sourceType,
    logSource,
    COUNT(1) AS hits,
    Nothing(Uint64?) AS ts -- (allways Null)
FROM (

        SELECT
            yuid AS id1,
            puid AS id2,
            IdType::YANDEXUID() AS id1Type,
            IdType::PUID() AS id2Type,
            SourceType::PASSPORT_AUTH() AS sourceType,
            $log_source AS logSource,
        FROM $fp_source
        WHERE (source == $condition)

    UNION ALL

        SELECT
            yuid AS id1,
            vk_com_id AS id2,
            IdType::YANDEXUID() AS id1Type,
            IdType::VK_ID() AS id2Type,
            SourceType::VK_APPS_REDIR() AS sourceType,
            $log_source AS logSource,
        FROM $fp_source
        WHERE (source == $condition)

    UNION ALL

        SELECT
            yuid AS id1,
            ok_ru_id AS id2,
            IdType::YANDEXUID() AS id1Type,
            IdType::OK_ID() AS id2Type,
            SourceType::OK_APPS_REDIR() AS sourceType,
            $log_source AS logSource,
        FROM $fp_source
        WHERE (source == $condition)

) WHERE id1 IS NOT NULL
    AND id2 IS NOT NULL
GROUP BY id1, id2, id1Type, id2Type, sourceType, logSource;
END DEFINE;

DO $make_fp_soup(LogSource::PASSPORT_LOG(), "p", LogSource::PASSPORT_LOG());
DO $make_fp_soup(LogSource::REQANS_LOG(), "r", LogSource::REQANS_LOG());
