$ua_limit = 100;

-- ========================================================================= --
-- Fill yuids raw

INSERT INTO $yuid_with_login_fp_table WITH TRUNCATE
SELECT
    yuid,
    COUNT(1) AS id_count,
    $date AS id_date,
    'login' as id_type,
    login as id_value,
    'fp' AS source_type
FROM $fp_source
WHERE login IS NOT Null
GROUP BY yuid, login
ORDER BY yuid
;

INSERT INTO $yuid_with_vk_fp_table WITH TRUNCATE
SELECT
    yuid,
    COUNT(1) AS id_count,
    $date AS id_date,
    'vk' AS id_type,
    vk_com_id AS id_value,
    'fp' AS source_type
FROM $fp_source
WHERE vk_com_id IS NOT Null
GROUP BY yuid, vk_com_id
ORDER BY yuid
;

INSERT INTO $yuid_with_ok_fp_table WITH TRUNCATE
SELECT
    yuid,
    COUNT(1) AS id_count,
    $date AS id_date,
    'ok' AS id_type,
    ok_ru_id AS id_value,
    'fp' AS source_type
FROM $fp_source
WHERE ok_ru_id IS NOT Null
GROUP BY yuid, ok_ru_id
ORDER BY yuid
;

INSERT INTO $yuid_with_puid_fp_table WITH TRUNCATE
SELECT
    yuid,
    COUNT(1) AS id_count,
    $date AS id_date,
    'puid' AS id_type,
    puid AS id_value,
    'fp' AS source_type
FROM $fp_source
WHERE puid IS NOT Null
GROUP BY yuid, puid
ORDER BY yuid
;

$ts_week_after = DateTime::ToSeconds(CAST('{{ date }}' as Date) + DateTime::IntervalFromDays(7));

$get_yandexuid_creation_date = ($yandexuid_str) -> {
    -- TODO: Use identifiers LIB
    $l = LENGTH($yandexuid_str);
    $ts_part = SUBSTRING($yandexuid_str, $l - 10u);  -- timestamp takes last 10 symbols
    $ts = CAST($ts_part as UInt32);
    return IF(
        $ts > 1000000000ul and $ts < $ts_week_after,
        CAST(DateTime::MakeDate(DateTime::FromSeconds($ts)) AS String)
    );
};


$yuid_with_info = (
    SELECT
        yuid,
        COUNT(1) AS id_count,
        $date AS id_date,
        MAX(ts) as last_ts,
        AGGREGATE_LIST_DISTINCT(source) AS sources,

        $get_yandexuid_creation_date(yuid) as yuid_creation_date,

        MAX_BY(ua_profile, IF(ua_profile IS NOT NULL, ts)) as ua_profile,
        MAX_BY(user_agent, IF(user_agent IS NOT NULL, ts)) as user_agent,
        MAX_BY(wapprofile, IF(wapprofile IS NOT NULL, ts)) as wapprofile,
        MAX_BY(browser, IF(browser IS NOT NULL, ts)) as browser,
        MAX_BY(browser_version, IF(browser_version IS NOT NULL, ts)) as browser_version,
        MAX_BY(webview, IF(webview IS NOT NULL, ts)) as webview,

        AGGREGATE_LIST_DISTINCT(user_agent, $ua_limit) AS multi_user_agent,

        AGGREGATE_BY(
            log_region_id,
            $aggregate_sum_dict
        ) as log_region_ids,

        AGGREGATE_BY(
            ip_region_id,
            $aggregate_sum_dict
        ) as ip_region_ids,

        $get_main_regions(
            AGGREGATE_BY(
                ip_region_id,
                $aggregate_sum_dict
            )
        ) AS ip_main_regions,

        -- 255 geo id of Russia
        COUNT_IF(ip_region_id IS NOT NULL AND Geo::IsRegionInRegion(ip_region_id, 225)) AS ip_rus_regions,
        COUNT_IF(ip_region_id IS NOT NULL AND NOT Geo::IsRegionInRegion(ip_region_id, 225)) AS ip_not_rus_regions

    FROM $fp_source
    GROUP BY yuid
);

INSERT INTO $yuid_with_info_table WITH TRUNCATE
SELECT
    yuid,
    'info' as id_type,
    $date as id_date,
    last_ts,
    sources ?? ListCreate(String) AS sources,
    yuid_creation_date,

    ua_profile,
    user_agent,
    wapprofile,
    browser,
    browser_version,
    IF(ListLength(multi_user_agent) > 1, multi_user_agent, Null) as multi_user_agent,

    $dump_as_dict_int(
        log_region_ids
    ) as log_region_ids,

    $dump_as_dict_int(
        ip_region_ids
    ) as ip_region_ids,

    -- use ip regions as source of truth for now
    ip_main_regions.main_region_country as main_region_country,
    ip_main_regions.main_region_obl as main_region_obl,
    ip_main_regions.main_region_city as main_region_city,
    ip_main_regions.main_region as main_region,
FROM $yuid_with_info
ORDER BY yuid, id_date
;

-- Fill yuids ua

INSERT INTO $yuids_ua_day_table WITH TRUNCATE
SELECT
    yuid,
    id_count,
    id_date,
    String::JoinFromList(
        sources, ','
    ) AS sources,
    user_agent AS ua,
    wapprofile ?? '' AS wp,
    $max_int - last_ts AS ts
FROM $yuid_with_info
ORDER BY yuid
;

-- Fill uaprofile

$yuids_dev_day_query = (
    SELECT
        yuid,
        ua_profile,
        browser,
        browser_version,
        COUNT(1) AS id_count
    FROM $fp_source
    GROUP BY
        yuid,
        ua_profile,
        browser,
        browser_version
);

-- TODO: may be use single table for m| and d| yuids
INSERT INTO $yuids_mob_day_table WITH TRUNCATE
SELECT * FROM $yuids_dev_day_query
WHERE String::StartsWith(ua_profile, 'm')
ORDER BY yuid
;

INSERT INTO $yuids_desk_day_table WITH TRUNCATE
SELECT * FROM $yuids_dev_day_query
WHERE String::StartsWith(ua_profile, 'd')
ORDER BY yuid
;

INSERT INTO $yuids_rus_ip_day_table WITH TRUNCATE
SELECT
    yuid,
    True as rus
FROM $yuid_with_info
WHERE ip_rus_regions > 0
    AND ip_not_rus_regions == 0 -- rus only
ORDER BY yuid
;
