from __future__ import print_function
import os

from crypta.lib.python.yql_runner.base_parser import BaseParser


class Fuzzy2Parser(BaseParser):

    """ Run YQL query to make fuzzy2 sources """

    # input directories
    BSWATCH_LOG_DIR = "//home/logfeller/logs/bs-watch-log/1d"
    QUERY_TEMPLATE = "fuzzy2.sql.j2"

    def __init__(self, date_start, date_end, is_day_task, fuzzy2_use_un=True, **kwargs):
        super(Fuzzy2Parser, self).__init__(date=date_end, **kwargs)
        self.date_start = date_start
        self.date_end = date_end
        self.is_day_task = is_day_task
        self.fuzzy2_use_un = fuzzy2_use_un

    def get_dirs(self):
        """ Get current environ and replace directories path to env """
        dirs = super(Fuzzy2Parser, self).get_dirs()
        dirs.update(
            bswatch_log_dir=(os.environ.get("LOGFELLER_BS_WATCH_FOLDER") or self.BSWATCH_LOG_DIR).rstrip("/") or "/"
        )
        return dirs

    def get_context_data(self, **kwargs):
        context = super(Fuzzy2Parser, self).get_context_data(**kwargs)
        context.update(
            date_start=self.date_start,
            date_end=self.date_end,
            is_day_task=self.is_day_task,
            fuzzy2_use_un=self.fuzzy2_use_un,
        )
        return context
