from crypta.lib.python.yql_runner.base_parser import BaseParser


class MetrikaUserParamsParser(BaseParser):
    QUERY_TEMPLATE = "metrika_user_params_query.sql.j2"

    def __init__(
        self,
        metrika_dir,
        output,
        *args, **kwargs
    ):

        self.metrika_dir = metrika_dir
        self.output = output

        super(MetrikaUserParamsParser, self).__init__(*args, **kwargs)

    def get_context_data(self, **kwargs):
        return super(MetrikaUserParamsParser, self).get_context_data(
            metrika_dir=self.metrika_dir,
            output=self.output,
            **kwargs
        )


class MobmetPreprocessing(BaseParser):
    QUERY_TEMPLATE = "preprocess_params_owner.sql.j2"

    def __init__(
        self,
        metrika_dir,
        mobmet_app_id_and_domains,
        mobmet_counters_and_domains,
        output_cross_mobmet,
        output_params_owners,
        *args,
        **kwargs
    ):

        self.metrika_dir = metrika_dir
        self.mobmet_app_id_and_domains = mobmet_app_id_and_domains
        self.mobmet_counters_and_domains = mobmet_counters_and_domains
        self.output_cross_mobmet = output_cross_mobmet
        self.output_params_owners = output_params_owners

        super(MobmetPreprocessing, self).__init__(*args, **kwargs)

    def get_context_data(self, **kwargs):
        return super(MobmetPreprocessing, self).get_context_data(
            metrika_dir=self.metrika_dir,
            mobmet_app_id_and_domains=self.mobmet_app_id_and_domains,
            mobmet_counters_and_domains=self.mobmet_counters_and_domains,
            output_cross_mobmet=self.output_cross_mobmet,
            output_params_owners=self.output_params_owners,
            **kwargs
        )
