$metrika_dir = "{{ metrika_dir }}";

$app_id_and_domains = "{{ mobmet_app_id_and_domains }}";
$counters_and_domains = "{{ mobmet_counters_and_domains }}";

-- ========================================================================= --
-- prepare MOBMET

$white_cross_counters = {
    24226447, -- metrika.yandex.com
    24226447, -- metrika.yandex.ru (there are also edges on the counter 41827589, but we do not take them into account due to the fact that we read only the main column)
    45513396, -- eda.yandex
    33709249, -- domclick.ru
    22753222, -- auto.ru
    51987098, -- bayt.com
    25951016, -- megafon.tv
    16888873, -- mybook.ru
    5901091,  -- sunlight.net
    56226271, -- lagruyere.ch
    47628343, -- beru.ru
};


PRAGMA yt.InferSchema = '1'; -- TODO: remove after schema is fixed

$app_id_and_domains_filtered =
SELECT
    web_site AS domain,
    AppID,
    String::ToLower(OperatingSystem) AS OperatingSystem
FROM $app_id_and_domains
WHERE web_site != '';

$counters_and_domains_filtered =
SELECT
   domain,
   CounterID
FROM $counters_and_domains
WHERE CounterID IN $white_cross_counters;

$joined_appid_and_counterids = SELECT
    apps.AppID AS AppID,
    apps.OperatingSystem AS OperatingSystem,
    counters.CounterID AS CounterID,
FROM $app_id_and_domains_filtered AS apps
JOIN $counters_and_domains_filtered AS counters
USING (domain);

$output_cross_mobmet = "{{ output_cross_mobmet }}";
INSERT INTO $output_cross_mobmet WITH TRUNCATE
SELECT * FROM $joined_appid_and_counterids;

-- ========================================================================= --
-- prepare metrika counters

$white_counters = SELECT ToSet(AGGREGATE_LIST_DISTINCT(CounterID)) FROM $joined_appid_and_counterids;

$output_params_owners = "{{ output_params_owners }}";
INSERT INTO $output_params_owners WITH TRUNCATE
SELECT
    counter_id AS CounterID,
    client_user_id AS ProfileID,
    CAST(user_id AS String) AS yandexuid,
FROM LIKE($metrika_dir,  'param_owners_%') AS metrika
WHERE client_user_id IS NOT NULL
    AND client_user_id NOT IN ('', '""', '0')
    AND counter_id IN UnWrap($white_counters);
