$metrika_dir = "{{ metrika_dir }}";


$allowed_counters = {
    -- filter https://yql.yandex-team.ru/Operations/X6qXlRpqvwsqQNbuQVnbX_itkAocbrGcZIabszc29Ys=
    3419323,
    6274279,
    6966829,
    8828512,
    9905320,
    10554589,
    11378869,
    14808064,
    16221463,
    17266678,
    19188001,
    20184619,
    21241063,
    21727927,
    23646274,
    23854201,
    24226447,
    24410659,
    25007642,
    25504241,
    27277514,
    29265845,
    31301378,
    31972361,
    34395475,
    37079940,
    37290365,
    38892630,
    38926670,
    38934205,
    39080290,
    39092120,
    39253580,
    40896699,
    41694319,
    41827589,
    41942834,
    42384909,
    43258924,
    44502073,
    44530279,
    45103497,
    46035735,
    46262670,
    46284006,
    46458240,
    46484202,
    47500810,
    47714683,
    48371996,
    48891032,
    49306963,
    49419400,
    49868617,
    49871998,
    49947829,
    50180737,
    50257837,
    50283046,
    50331643,
    50727076,
    50784928,
    50788756,
    50788801,
    50853837,
    51010208,
    51120638,
    51596174,
    51654653,
    51675113,
    51744377,
    51831782,
    51861818,
    51912854,
    51962054,
    52067445,
    52265005,
    52808110,
    52845181,
    53765878,
    54016048,
    54317190,
    54799495,
    54917527,
    55591738,
    55829020,
    55829044,
    55840441,
    55914760,
    56704261,
    56780818,
    56834152,
    57128413,
    57496230,
    61142524,
    61577092,
    62843233,
    65400532
};

$email_path = [
    "login",
    "email",
    "e-mail",
    "$email",
];

$phone_path = [
    "phone",
];

$vkid_path = [
    "vk_user_id",
];

$okid_path = [
    "ok_id",
];

-- ========================================================================= --

$allowed_params = (
    SELECT
        update_time,
        Identifiers::NormalizeYandexuid(CAST(user_id AS String)) AS yandexuid,
        param_path,
        value_string,
        value_double,
    FROM LIKE($metrika_dir, "params_%")
    WHERE counter_id IN $allowed_counters
        AND Identifiers::IsValidYandexuid(CAST(user_id AS String))
        AND param_path IN ToSet(ListExtend(
            $email_path, $phone_path, $vkid_path, $okid_path
        ))
);

$date_format = DateTime::Format("%Y-%m-%d");
$get_date = ($ts) -> ( $date_format(DateTime::FromMilliseconds($ts)) );
$get_integer_str = ($double) -> ( CAST(CAST($double AS Int64) AS String) );


DEFINE SUBQUERY $make_edges($validator, $normalizer, $id2_type, $param_paths) AS
    SELECT
        $get_date(MAX(update_time)) AS `date`,
        yandexuid AS id1,
        IdType::YANDEXUID() AS id1Type,
        MAX_BY(
            IF(
                $validator(value_string),
                $normalizer(value_string),
                $normalizer($get_integer_str(value_double))
            ), update_time
        ) AS id2,
        $id2_type AS id2Type,
        SourceType::METRICA_USER_PARAMS() AS sourceType,
        LogSource::METRIKA_USERPARAMS() AS logSource,
    FROM $allowed_params
    WHERE
        param_path IN ToSet($param_paths) AND ($validator(value_string) OR $validator($get_integer_str(value_double)))
    GROUP BY yandexuid, value_string, value_double;
END DEFINE;

$output =  "{{ output }}";
INSERT INTO $output WITH TRUNCATE
SELECT * FROM $make_edges(Identifiers::IsValidEmail, Identifiers::NormalizeEmail, IdType::EMAIL(), $email_path)
UNION ALL
SELECT * FROM $make_edges(Identifiers::IsValidPhone, Identifiers::NormalizePhone, IdType::PHONE(), $phone_path)
UNION ALL
SELECT * FROM $make_edges(Identifiers::IsValidVkId, Identifiers::NormalizeVkId, IdType::VK_ID(), $vkid_path)
UNION ALL
SELECT * FROM $make_edges(Identifiers::IsValidOkId, Identifiers::NormalizeOkId, IdType::OK_ID(), $okid_path)
