$passport_userdata = "{{ userdata_tbl }}";
$soup_output_dir = "{{ soup_out_dir }}";

$edge = ($id1, $id2, $st, $ls) -> {
    RETURN "/" || String::JoinFromList([$id1, $id2, $st, $ls], "_");
};

$log = (
    SELECT
        Identifiers::NormalizePuid(uid) AS puid,
        Identifiers::NormalizeLogin(login) AS login,
        ListMap(phone_numbers, Identifiers::NormalizePhone) AS phones,
    FROM $passport_userdata{% if is_test_run %} VIEW test{% endif %}
    WHERE Identifiers::IsSignificantPuid(uid)
);

$out_login_tbl = $soup_output_dir || $edge(IdType::PUID(), IdType::LOGIN(), SourceType::PASSPORT_PROFILE(), LogSource::PASSPORT_DICT());
INSERT INTO $out_login_tbl WITH TRUNCATE
SELECT
    id1,
    IdType::PUID() AS id1Type,
    id2,
    IdType::LOGIN() AS id2Type,
    SourceType::PASSPORT_PROFILE() AS sourceType,
    LogSource::PASSPORT_DICT() AS logSource,
    ListCreate(String) AS dates
FROM $log
WHERE Identifiers::IsSignificantLogin(login)
GROUP BY
    puid AS id1,
    login AS id2
;

$out_login_tbl = $soup_output_dir || $edge(IdType::PUID(), IdType::PHONE(), SourceType::PASSPORT_PROFILE(), LogSource::PASSPORT_PHONE_DUMP());
INSERT INTO $out_login_tbl WITH TRUNCATE
SELECT
    id1,
    IdType::PUID() AS id1Type,
    id2,
    IdType::PHONE() AS id2Type,
    SourceType::PASSPORT_PROFILE() AS sourceType,
    LogSource::PASSPORT_PHONE_DUMP() AS logSource,
    ListCreate(String) AS dates
FROM (
    SELECT DISTINCT puid, phone
    FROM $log FLATTEN LIST BY phones AS phone
) WHERE Identifiers::IsSignificantPhone(phone)
GROUP BY
    puid AS id1,
    phone AS id2
;
