PRAGMA yson.DisableStrict;
PRAGMA RegexUseRe2='true';

{% if not is_embedded %}
PRAGMA Library = 'metrica_lib.sql';
{% endif %}


IMPORT {% if is_embedded %}.lib.{% endif %}metrica_lib SYMBOLS
    $force_null
;

-- input tables
$postback_log_tables = AsList(
    '{{ input | join("', '") | safe }}'
);

-- output tables
$postback_soup = "{{ output }}";
$postback_apps_table = "{{ output_extra_data_dir }}/{{ date }}/postback_apps_table/{{ uniqid }}";

$clean = ($type, $value) -> {
    RETURN IF(Identifiers::IsSignificant($type, $value), Identifiers::Normalize($type, $value), null);
};

$date_format = DateTime::Format("%Y-%m-%d");
$get_dt = ($ts) -> {
    RETURN $date_format(DateTime::FromSeconds(Unwrap(CAST($ts AS UInt32))));
};

$limit_apps = 150;
$bad_app = @@([\-\/:\[\]\?,\\"'!;])|(^\d+$)@@;  -- " -- quote to fix syntax highlight

-- ========================================================================= --

$postback_apps =
SELECT
    _logfeller_timestamp AS ts,
    PackageName AS app,
    COALESCE(
        $clean(IdType::IDFA(), IDFA),
        $clean(IdType::IFV(), IDFV),
        $clean(IdType::GAID(), GoogleAdID),
        $clean(IdType::OAID(), OAID),
    ) AS device_id,
    $clean(IdType::IDFA(), IDFA) AS idfa,
    $clean(IdType::IFV(), IDFV) AS ifv,
    $clean(IdType::GAID(), GoogleAdID) AS google_adv_id,
    $clean(IdType::OAID(), OAID) AS open_id,
    CASE
        WHEN $force_null(IDFA) IS NOT NULL OR $force_null(IDFV) IS NOT NULL THEN "ios"
        ELSE "android"
    END AS os
FROM EACH($postback_log_tables)
WHERE PackageName IS NOT NULL AND PackageName NOT REGEXP $bad_app;

$postback_presoup = (
    SELECT
        {
            IdType::IDFA(): IDFA,
            IdType::GAID(): IDFV,
            IdType::OAID(): GoogleAdID,
            IdType::IFV(): OAID,
            -- IdType::MM_DEVICE_ID(): NULL
        } AS device_dict,
        {
            IdType::EMAIL_SHA256(): EmailHash,
            IdType::EMAIL_MD5(): EmailHash,
            IdType::PHONE_SHA256(): PhoneHash,
            IdType::PHONE_MD5(): PhoneHash,
        } AS hash_dict,
        $get_dt(_logfeller_timestamp) AS dt,
    FROM EACH($postback_log_tables)
);

INSERT INTO $postback_apps_table WITH TRUNCATE
SELECT
    MAX(ts) AS ts,
    $get_dt(MAX(ts)) AS dt,
    AsList($get_dt(MAX(ts))) AS dates,

    os,
    ListSort(AGGREGATE_LIST_DISTINCT(app, $limit_apps)) AS postback_apps,
    device_id,
    SOME(idfa) AS idfa,
    SOME(ifv) AS ifv,
    SOME(open_id) AS open_id,
    SOME(google_adv_id) AS google_adv_id,

    ListCreate(String) AS metrica_apps,
    ListCreate(String) AS macs,

    LogSource::POSTBACK_LOG() as source,
FROM $postback_apps
WHERE device_id IS NOT NULL
GROUP BY device_id, os;

DEFINE SUBQUERY $make_fpp_soup($id1Type, $id2Type) AS
    SELECT
        $id1Type AS id1Type,
        $id2Type AS id2Type,
        id1,
        id2,
        SourceType::FIRST_PARTY_PARAMS() AS sourceType,
        LogSource::POSTBACK_LOG() as logSource,
        AGGREGATE_LIST_DISTINCT(dt) AS dates,
    FROM (
        SELECT
            dt,
            UNWRAP(device_dict[$id1Type]) AS id1,
            UNWRAP(hash_dict[$id2Type]) AS id2
        FROM $postback_presoup
        WHERE DictContains(device_dict, $id1Type)
            AND DictContains(hash_dict, $id2Type)
    ) WHERE Identifiers::IsSignificant($id1Type, id1)
        AND Identifiers::IsSignificant($id2Type, id2)
    GROUP BY id1, id2;
END DEFINE;

DEFINE SUBQUERY $make_fpp_soup_email($id_type) AS
    SELECT * FROM $make_fpp_soup($id_type, IdType::EMAIL_SHA256())
    UNION ALL
    SELECT * FROM $make_fpp_soup($id_type, IdType::EMAIL_MD5());
END DEFINE;

DEFINE SUBQUERY $make_fpp_soup_phone($id_type) AS
    SELECT * FROM $make_fpp_soup($id_type, IdType::PHONE_SHA256())
    UNION ALL
    SELECT * FROM $make_fpp_soup($id_type, IdType::PHONE_MD5());
END DEFINE;

$devices = [IdType::IDFA(), IdType::GAID(), IdType::OAID(), IdType::IFV(), IdType::MM_DEVICE_ID()];

$email_hash_soup = SubqueryExtendFor($devices, $make_fpp_soup_email);
$phone_hash_soup = SubqueryExtendFor($devices, $make_fpp_soup_phone);

$union_soup = (
    PROCESS $email_hash_soup()
    UNION ALL
    PROCESS $phone_hash_soup()
);

INSERT INTO $postback_soup
WITH TRUNCATE
SELECT *
FROM $union_soup;
