import contextlib
import datetime

from crypta.graph.soup.config.python import LOG_SOURCE
from crypta.graph.data_import.stream.lib.tasks.base import StreamBaseYqlTask, Parameter

import crypta.lib.python.bt.conf.conf as conf


class PostbackLogTask(StreamBaseYqlTask):
    """ Parse postback log """

    log_source = LOG_SOURCE.POSTBACK_LOG
    limit = Parameter(parse=int, default=72)  # 60 / 5 (tables per hour) * 3 (task timelimit alert) == 36 * 2 --> 72

    def observed_paths(self):
        yield conf.paths.logfeller.postback_uniform_log.stream
        # yield conf.paths.logfeller.postback_log.stream

    @property
    def query_template(self):
        return "postback_log.sql.j2"

    def run(self, *args, **kwargs):
        if not self._assert_tables_ready(self.unprocessed_tables, self.input_tables):
            return
        return super(PostbackLogTask, self).run(*args, **kwargs)

    @contextlib.contextmanager
    def run_context(self):
        with super(PostbackLogTask, self).run_context() as ctx:
            yield ctx
        self._set_expiration()

    def _set_expiration(self):
        self.yt.set(
            "{path}/{date:%Y-%m-%d}/@expiration_time".format(path=self.output_extra_data_dir, date=self.date),
            "{date:%Y-%m-%d} 12:00:00.0+00:00".format(date=self.date + datetime.timedelta(days=conf.proto.DaysTTL)),
        )
