from __future__ import print_function
import os

from crypta.lib.python.yql_runner.base_parser import BaseParser


class RadiusFilter(BaseParser):

    """ Run YQL query to filter mobile metrica and watchlog by radius ips """

    # input directories
    BSWATCH_LOG_DIR = "//home/logfeller/logs/bs-watch-log/1d"
    RADIUS_LOG_DIR = "//home/crypta/{crypta_env}/state/radius/log"

    QUERY_TEMPLATE = "radius.sql.j2"

    def get_dirs(self):
        """ Get current environ and replace directories path to env """
        dirs = super(RadiusFilter, self).get_dirs()
        radius_log_dir = (
            os.environ.get("RADIUS_LOG_YT_FOLDER") or self.RADIUS_LOG_DIR.format(crypta_env=self.crypta_env)
        ).rstrip("/") or "/"
        bswatch_log_dir = os.environ.get("LOGFELLER_BS_WATCH_FOLDER", self.BSWATCH_LOG_DIR).rstrip("/")
        dirs.update(radius_log_dir=radius_log_dir, bswatch_log_dir=bswatch_log_dir)
        return dirs
