PRAGMA yt.DataSizePerJob = '6G';

$date = '{{ date }}';
$yt_output_folder = '{{ graph_output_dir }}';

-- input tables
$radius_ips_log = '{{ radius_log_dir }}/{{ date }}/all_radius_ips';
$watchlog = '{{ bswatch_log_dir }}/{{ date }}';

-- output tables
$watchlog_radius = $yt_output_folder || '/' || $date || '/raw_links/watch_log_filtered_by_radius';

-- ========================================================================= --


$radius_ips_query = (
    SELECT DISTINCT ip FROM (
        SELECT Yson::ConvertToString(ip) AS ip FROM $radius_ips_log
    )
);


DEFINE ACTION $filter_watch_log_radius() AS

    $watchlog_ips = (
        SELECT
            yuid,
            ips.ip AS ip,
            ips.ip_type AS ip_type,
            ts AS `timestamp`,
            rec_type
        FROM (
            SELECT
                uniqid AS yuid,
                CAST(eventtime AS Int64) AS ts,
                'watch' AS rec_type,
                AsList(
                    AsStruct(
                        clientip AS ip,
                        'IPv4' AS ip_type,
                    ),
                    AsStruct(
                        clientip6 AS ip,
                        'IPv6' AS ip_type,
                    )
                ) AS ips
            FROM $watchlog
        ) FLATTEN LIST BY ips
    );

    INSERT INTO $watchlog_radius WITH TRUNCATE
    SELECT
        wl.yuid AS yuid,
        wl.ip AS ip,
        wl.ip_type AS ip_type,
        wl.`timestamp` AS `timestamp`,
        wl.rec_type AS rec_type
    FROM $watchlog_ips AS wl
    LEFT SEMI JOIN $radius_ips_query AS radius USING (ip)
    WHERE yuid IS NOT Null AND wl.ip IS NOT Null
    ORDER BY ip, `timestamp`;

END DEFINE;

-- ========================================================================= --

DO $filter_watch_log_radius();
