PRAGMA yson.DisableStrict;
PRAGMA RegexUseRe2='true';

{% if not is_embedded %}
PRAGMA Library = 'metrica_lib.sql';
{% endif %}

$date_format = DateTime::Format("%Y-%m-%d");

-- tables to use
-- input tables
$rtb_log_tables = AsList(
    '{{ input | join("', '") | safe }}'
);

-- output tables
$ssp_apps_info_table = "{{ output_extra_data_dir }}/{{ date }}/ssp_apps_info_table/{{ uniqid }}";
$allowed_sspid_gaid_table = "{{ allowed_sspid_gaid_table }}";
$out_soup = '{{ output }}';

$clean = ($type, $value) -> {
    RETURN IF(Identifiers::IsSignificant($type, $value), Identifiers::Normalize($type, $value), null);
};

-- ========================================================================= --

$bad_app = @@([\-\/:\[\]\?,\\"'!;])|(^\d+$)@@;  -- " -- quote to fix syntax highlight
$parsed_rtb_apps = (
    SELECT
        ts,
        dt,
        AsList(dt) as dates,

        os,
        ListSort(ssp_apps) AS ssp_apps,
        device_id,
        idfa,
        ifv,
        open_id,
        google_adv_id,

        ListCreate(String) AS metrica_apps,
        ListCreate(String) AS macs,

        -- CRYPTA-13825
        LogSource::BS_RTB_LOG() as source
    FROM (
        SELECT
            MAX(ts) AS ts,
            $date_format(DateTime::FromSeconds(
                Unwrap(CAST(MAX(ts) AS UInt32))
            )) AS dt,
            os,
            AGGREGATE_LIST_DISTINCT(app, 150) AS ssp_apps,
            device_id,
            SOME(idfa) AS idfa,
            SOME(ifv) AS ifv,
            SOME(open_id) AS open_id,
            SOME(google_adv_id) AS google_adv_id,
        FROM (
            SELECT
                ts,
                device_id,
                app,
                os,
                idfa,
                ifv,
                google_adv_id,
                open_id
            FROM (
                SELECT
                    _logfeller_timestamp AS ts,
                    COALESCE(
                        $clean(IdType::IDFA(), idfa),
                        $clean(IdType::IFV(), ifv),
                        $clean(IdType::GAID(), gaid),
                        $clean(IdType::OAID(), oaid),
                    ) AS device_id,
                    $clean(IdType::IDFA(), idfa) AS idfa,
                    $clean(IdType::IFV(), ifv) AS ifv,
                    $clean(IdType::GAID(), gaid) AS google_adv_id,
                    $clean(IdType::OAID(), oaid) AS open_id,
                    bundleid AS app,
                    String::AsciiToLower(Url::Decode(DictLookup(Dsv::Parse(queryargs, "&"), "329"))) AS os,
                FROM EACH($rtb_log_tables)
            ) WHERE
                device_id IS NOT NULL
                AND app IS NOT NULL
                AND (os ?? '') IN ('ios', 'android')
                AND app NOT REGEXP $bad_app
        ) GROUP BY device_id, os
    )
);

$parsed_rtb_for_edges = (
    SELECT
        $clean(IdType::IDFA(), idfa) AS idfa,
        $clean(IdType::IFV(), ifv) AS ifv,
        $clean(IdType::GAID(), gaid) AS gaid,
        $date_format(DateTime::FromSeconds(CAST(_logfeller_timestamp AS UInt32) ?? 0)) AS dt,
        sspid as sspid,
        $clean(
            IdType::SSP_USER_ID(),
            sspid || "@" || Url::Decode(DictLookup(Dsv::Parse(queryargs, "&"), "1028"))
        ) as ssp_user_id
    FROM
        EACH($rtb_log_tables)
    WHERE
        CAST(sspid AS int64) > 10000
);

$ifv_idfa_edges = (
    SELECT
        ifv AS id1,
        IdType::IFV() AS id1Type,
        idfa AS id2,
        IdType::IDFA() AS id2Type,
        LogSource::BS_RTB_LOG() AS logSource,
        SourceType::RTB() AS sourceType,
        AGGREGATE_LIST_DISTINCT(dt) AS dates
    FROM $parsed_rtb_for_edges
    WHERE
        ifv IS NOT NULL
        AND idfa IS NOT NULL
    GROUP BY ifv, idfa
);

$ssp_idfa_edges = (
    SELECT
        ssp_user_id AS id1,
        IdType::SSP_USER_ID() AS id1Type,
        idfa AS id2,
        IdType::IDFA() AS id2Type,
        LogSource::BS_RTB_LOG() AS logSource,
        SourceType::RTB() AS sourceType,
        AGGREGATE_LIST_DISTINCT(dt) AS dates
    FROM $parsed_rtb_for_edges
    WHERE
        idfa IS NOT NULL
        AND ssp_user_id IS NOT NULL
    GROUP BY ssp_user_id, sspid, idfa
);

$ssp_ifv_edges = (
    SELECT
        ssp_user_id AS id1,
        IdType::SSP_USER_ID() AS id1Type,
        ifv AS id2,
        IdType::IFV() AS id2Type,
        LogSource::BS_RTB_LOG() AS logSource,
        SourceType::RTB() AS sourceType,
        AGGREGATE_LIST_DISTINCT(dt) AS dates
    FROM $parsed_rtb_for_edges
    WHERE
        ifv IS NOT NULL
        AND ssp_user_id IS NOT NULL
    GROUP BY ssp_user_id, sspid, ifv
);

$ssp_gaid_edges = (
    SELECT
        ssp_user_id AS id1,
        IdType::SSP_USER_ID() AS id1Type,
        gaid AS id2,
        IdType::GAID() AS id2Type,
        LogSource::BS_RTB_LOG() AS logSource,
        SourceType::RTB() AS sourceType,
        AGGREGATE_LIST_DISTINCT(dt) AS dates
    FROM $parsed_rtb_for_edges
    WHERE
        gaid IS NOT NULL
        AND ssp_user_id IS NOT NULL
        AND sspid IN (SELECT sspid FROM $allowed_sspid_gaid_table)
    GROUP BY ssp_user_id, sspid, gaid
);

INSERT INTO $out_soup WITH TRUNCATE
SELECT * from $ifv_idfa_edges
UNION ALL
SELECT * from $ssp_idfa_edges
UNION ALL
SELECT * from $ssp_ifv_edges
UNION ALL
SELECT * from $ssp_gaid_edges;


INSERT INTO $ssp_apps_info_table WITH TRUNCATE
SELECT * FROM $parsed_rtb_apps;
