import contextlib
import datetime

from crypta.graph.soup.config.python import LOG_SOURCE
from crypta.graph.data_import.stream.lib.tasks.base import StreamBaseYqlTask, Parameter

import crypta.lib.python.bt.conf.conf as conf


class RTBLogTask(StreamBaseYqlTask):
    """ Parse rtb log as bt task """

    log_source = LOG_SOURCE.BS_RTB_LOG
    limit = Parameter(parse=int, default=10)
    ALLOWED_SSPID_GAID_TABLE = "//home/crypta/{crypta_env}/graph/config/allowed_sspid_gaid"

    def observed_paths(self):
        yield conf.paths.logfeller.rtb_log.stream

    @property
    def query_template(self):
        return "rtb_log.sql.j2"

    def get_context_data(self, **kwargs):
        context = super(RTBLogTask, self).get_context_data(**kwargs)
        context.update(allowed_sspid_gaid_table=self.ALLOWED_SSPID_GAID_TABLE.format(crypta_env=self.crypta_env))
        return context

    def run(self, *args, **kwargs):
        if not self._assert_tables_ready(self.unprocessed_tables, self.input_tables):
            return
        return super(RTBLogTask, self).run(*args, **kwargs)

    @contextlib.contextmanager
    def run_context(self):
        with super(RTBLogTask, self).run_context() as ctx:
            yield ctx
        self._set_expiration()

    def _set_expiration(self):
        self.yt.set(
            "{path}/{date:%Y-%m-%d}/@expiration_time".format(path=self.output_extra_data_dir, date=self.date),
            "{date:%Y-%m-%d} 12:00:00.0+00:00".format(date=self.date + datetime.timedelta(days=conf.proto.DaysTTL)),
        )
