from __future__ import print_function

from crypta.graph.soup.config.python import EDGE_TYPE
from crypta.lib.python.yql_runner.base_parser import BaseParser


def get_daily_edges():
    return [
        edge
        for edge in EDGE_TYPE.values()
        if (
            edge.Props.ActivityType == edge.Props.DAILY
            and edge.Props.SupplyMethod == edge.Props.LOG
            and edge.Usage.SoupUpdate
        )
    ]


class AddDaySoup(BaseParser):

    """Run YQL query to update daily soup"""

    # input directories
    QUERY_TEMPLATE = "soup.sql.j2"

    def __init__(
        self,
        soup_dir,
        throw_before_date,
        log_source=None,
        transaction_id=None,
        edge_types=None,
        normalize_lazy=True,
        **kwargs
    ):
        super(AddDaySoup, self).__init__(**kwargs)
        self.transaction_id = transaction_id
        self.soup_dir = soup_dir
        self.throw_before_date = throw_before_date
        self.log_source = log_source
        self.normalize_lazy = normalize_lazy

        if edge_types is not None:
            self.edge_types = edge_types
        elif log_source is not None:
            self.edge_types = [x for x in get_daily_edges() if x.LogSource == log_source]
        else:
            self.edge_types = get_daily_edges()

    def get_context_data(self, **kwargs):
        context = super(AddDaySoup, self).get_context_data(**kwargs)
        context.update(
            stream=False,
            date=self.date,
            soup_dir=self.soup_dir.rstrip("/"),
            transaction_id=self.transaction_id,
            throw_before_date=self.throw_before_date,
            log_source_name=self.log_source.Name if self.log_source else "",
            edge_types=self.edge_types,
            normalize_lazy=self.normalize_lazy,
        )
        return context
