import logging
import sys

import crypta.lib.python.bt.tasks.tool2 as task
from crypta.lib.python.getoptpb import ParsePbOptions

import crypta.graph.data_import.stream.proto.config_pb2 as proto_config

import crypta.graph.data_import.access_log.lib  # noqa
import crypta.graph.data_import.app_metrica_day.lib.task  # noqa
import crypta.graph.data_import.bar_navig_log.lib  # noqa
import crypta.graph.data_import.export_access_log.lib  # noqa
import crypta.graph.data_import.postback_log.lib.task  # noqa
import crypta.graph.data_import.redir_log.lib  # noqa
import crypta.graph.data_import.rtb_log.lib.task  # noqa
import crypta.graph.data_import.soup.lib.task  # noqa
import crypta.graph.data_import.stream.lib.tasks  # noqa
import crypta.graph.data_import.watch_log.lib  # noqa

import crypta.lib.python.bt.conf.conf as conf
import crypta.lib.python.bt.conf.resource_conf as resource_conf
import library.python.resource as resource


def main():
    if not logging.root.handlers:
        logging.root.addHandler(logging.StreamHandler(sys.stderr))

    conf.use(resource_conf.find("/crypta/graph/data_import/stream"))
    proto = ParsePbOptions(proto_config.TStreamConfig)
    conf.use_proto(proto, defaults=resource.find(proto.DefaultsPath))

    sys.exit(task.main(conf.proto))


if __name__ == "__main__":
    main()
