PRAGMA yson.DisableStrict;

-- ========================================================================= --

DEFINE ACTION $make_edges($source_log, $out_phone_yuid_soup) AS

    $filtered_phones = ($phone) -> {RETURN ListFilter($phone, Identifiers::IsValidPhone);};

    $useful_fields = (
        SELECT DISTINCT
            yandexuid,
            Identifiers::NormalizePhone(phones) AS phone
        FROM (
            SELECT
                Identifiers::NormalizeYandexuid(CAST(UserID AS String)) as yandexuid,
                $filtered_phones(Goals_CallPhoneNumber) AS phones
            FROM $source_log()
            WHERE Identifiers::IsValidYandexuid(CAST(UserID AS String)) AND ListHasItems($filtered_phones(Goals_CallPhoneNumber))
        )
        FLATTEN LIST BY phones
    );

    INSERT INTO $out_phone_yuid_soup WITH TRUNCATE
    SELECT
        phone AS id1,
        IdType::PHONE() AS id1Type,
        yandexuid AS id2,
        IdType::YANDEXUID() AS id2Type,
        "{{ date }}" AS `date`,
        SourceType::METRIKA_OFFLINE_CONVERSION() AS sourceType,
        LogSource::VISIT_LOG() AS logSource,
        1 AS dayHits,
        Null AS dayActivity
    FROM $useful_fields;

END DEFINE;

-- ========================================================================= --

$visit_log = "{{ visit_log }}";
$visit_private_log = "{{ visit_private_log }}";
$out_phone_yuid_soup = "{{ out_phone_yuid_soup }}";

DEFINE SUBQUERY $source_log() AS
    SELECT * FROM CONCAT($visit_log, $visit_private_log)
    WITH COLUMNS Struct<Goals_CallPhoneNumber: List<String>?>;
END DEFINE;

DO $make_edges($source_log, $out_phone_yuid_soup);
