from __future__ import print_function
import os

from crypta.graph.data_import.stream.lib.tasks.base import StreamBaseYqlTask

from crypta.graph.soup.config.python import LOG_SOURCE

import crypta.lib.python.bt.conf.conf as conf


def wl_yql_libs():
    return [{"name": "wl_udf.py", "content": "wl_udf.py", "disposition": "resource", "type": "file"}]


class WatchLogImportTask(StreamBaseYqlTask):

    log_source = LOG_SOURCE.WATCH_LOG

    def __init__(self, version=None, **kwargs):
        super(WatchLogImportTask, self).__init__(version, **kwargs)
        self.tmp_sockets = None

    def observed_paths(self):
        yield conf.paths.logfeller.bs_watch_log.stream

    @property
    def query_template(self):
        return "wl_parse.sql.j2"

    @property
    def custom_tokens(self):
        return [
            {
                "name": "metrika",
                "value": os.getenv("METRIKA_PRIVATE_KEY").encode('ascii'),
            },
        ]

    def get_libs(self):
        libs = super(WatchLogImportTask, self).get_libs()
        libs.extend(wl_yql_libs())
        return libs

    def get_context_data(self, **kwargs):
        context = super(WatchLogImportTask, self).get_context_data(**kwargs)
        context.update(
            approved_domens_table="//home/crypta/{env}/graph/config/wl_client_user_id/approved_domens".format(env=self.crypta_env),
        )
        return context
