import json
import base64

from collections import Sequence, Mapping, namedtuple


def to_str(w):
    if isinstance(w, basestring):
        return w
    else:
        return str(w)


Ecommerce = namedtuple("Ecommerce", "action, name, category, revenue")


def _parse_ecommerce_json(json_str, good_actions):
    try:
        ecommerce = json.loads(json_str)["__ym"]["ecommerce"]
    except Exception:
        return

    if not isinstance(ecommerce, Sequence):
        return

    for ecommerce_item in ecommerce:
        if not isinstance(ecommerce_item, Mapping):
            continue
        for action, action_hash in ecommerce_item.iteritems():
            if (action not in good_actions) or (not isinstance(action_hash, Mapping)):
                continue

            revenue = 0
            action_field = action_hash.get("actionField")
            if action_field and isinstance(action_field, Mapping):
                revenue = action_field.get("revenue", 0)

            products = action_hash.get("products", [])
            if not isinstance(products, Sequence):
                continue
            for product in products:
                if not isinstance(product, Mapping):
                    continue
                # if both None or empty strings - it is bad product
                name = product.get("name") or product.get("id")
                category = product.get("category", "")

                if name:
                    yield Ecommerce(*map(to_str, (action, name, category, revenue)))


def parse_ecommerce(json_str):
    return list(_parse_ecommerce_json(json_str, {"purchase"})) if json_str else []


def decode_social_id(raw_value):
    # METR-22822
    try:
        x = base64.b64decode(raw_value)
        decode_x = x.decode("utf8")
        return "".join(chr(ord(ch) - 50) for ch in decode_x)
    except:
        return None
