from __future__ import print_function

import os
from crypta.lib.python.yql_runner.base_parser import BaseParser
from crypta.graph.data_import.webvisor.lib.webvisor_proto import webvisor_generate_attribute


class WebVisorParser(BaseParser):

    """ Run YQL query to parse webvisor 2 """

    # input directories
    WEBVISOR_LOG_DIR = "//home/logfeller/logs/bs-webvisor-log/1d"
    QUERY_TEMPLATE = "webvisor.sql.j2"

    def __init__(
        self,
        webvisor_processed,
        yuid_raw_email,
        yuid_raw_phone,
        soup_table,
        webvisor_tolerance,
        *args,
        **kwargs
    ):

        self.webvisor_processed = webvisor_processed
        self.yuid_raw_email = yuid_raw_email
        self.yuid_raw_phone = yuid_raw_phone
        self.soup_table = soup_table
        self.webvisor_tolerance = webvisor_tolerance

        super(WebVisorParser, self).__init__(*args, **kwargs)

    def get_libs(self):
        """ Return list of libraries with extra UD(A)Fs """

        def _libs(lib_key):
            partial = super(BaseParser, self).render(lib_key)
            name = "{0}_lib.sql".format(lib_key.split("/")[-1].split(".")[0])
            file_path = "/tmp/{}".format(name)
            with open(file_path, "w") as ofile:
                ofile.write(partial)

            yield {
                "name": file_path if self.is_embedded else name,
                "content": file_path,
                "disposition": "filesystem",
                "type": "library",
            }
            self._query = None

        libs = super(WebVisorParser, self).get_libs()
        libs.extend(_libs("/lib/wv.sql.j2"))
        libs.extend(_libs("/lib/proto.sql.j2"))

        return libs

    def get_context_data(self, **kwargs):
        context = super(WebVisorParser, self).get_context_data(
            webvisor_processed=self.webvisor_processed,
            yuid_raw_email=self.yuid_raw_email,
            yuid_raw_phone=self.yuid_raw_phone,
            soup_table=self.soup_table,
            webvisor_tolerance=self.webvisor_tolerance,
            **kwargs
        )
        context.update(
            {"metrika_wv2_{0}_config".format(key): value for key, value in webvisor_generate_attribute().iteritems()}
        )
        return context

    def get_dirs(self):
        """ Get current environ and replace directories path to env """
        dirs = super(WebVisorParser, self).get_dirs()
        dirs.update(webvisor_log_dir=(os.getenv("BS_WEBVISOR_LOG_FOLDER") or self.WEBVISOR_LOG_DIR).rstrip("/") or "/")
        return dirs
