-- ========================================================================== --
$_email_regex = Re2::Capture(@@^(?P<email>[a-zA-Z0-9._-]+@[a-zA-Z0-9._-]+\.[a-zA-Z0-9]+)$@@);
$_rus_phone_regex = Re2::Capture(
    @@^@@                            ||
    @@(?P<country>\+7|\+ 7|7|8)?@@   || -- country code
    @@[ \-]*@@                       || -- separator
    @@(?P<region>\(? ?9\d{2} ?\)?)@@ || -- region code with optional braces
    @@[ \-]*@@                       || -- separator
    @@(?P<number>[\d\- ]{7,10})@@    || -- rest number with optional separators
    @@$@@
);

$_ddmmyyyy_regex = Re2::Capture(
    @@^@@                ||
    @@(?P<day>\d{2})@@   || -- day
    @@([\./\-])@@        || -- delimiters
    @@(?P<month>\d{2})@@ || -- month
    @@([\./\-])@@        || -- delimiters
    @@(?P<year>\d{4})@@  || -- year
    @@$@@
);

$_yyyymmdd_regex = Re2::Capture(
    @@^@@                ||
    @@(?P<year>\d{4})@@  || -- year
    @@([\./\-])@@        || -- delimiters
    @@(?P<month>\d{2})@@ || -- month
    @@([\./\-])@@        || -- delimiters
    @@(?P<day>\d{2})@@   || -- day
    @@$@@
);

$_id_symbols_only_re = Re2::FindAndConsume(@@([A-Za-z0-9\-_]+)@@);
$_digits_only_re = Re2::FindAndConsume(@@(\d+)@@);
$id_symbols_only = ($value) -> {
    RETURN CASE
        WHEN $value IS NOT NULL
            THEN String::JoinFromList($_id_symbols_only_re(Unwrap($value)), '')
        ELSE NULL
    END;
};
$_digits_only = ($value) -> {
    RETURN String::JoinFromList($_digits_only_re($value), '');
};

$wv_parse_email = ($value) -> {
    $email = $_email_regex($value).email;
    RETURN IF($email > "", $email);
};

$wv_parse_phone = ($value) -> {
    $phone = $_rus_phone_regex($value);
    $region = $_digits_only($phone.region);
    $number = $_digits_only($phone.number);
    RETURN CASE
        WHEN (LENGTH($region) == 3 AND LENGTH($number) == 7)
            THEN '+7' || $region || $number
        ELSE NULL
    END;
};

$wv_parse_date = ($value) -> {
    $dd_yy = $_ddmmyyyy_regex($value);
    $yy_dd = $_yyyymmdd_regex($value);

    $to_date = ($group) -> {
        RETURN CASE
            WHEN ($group._1 == $group._2)
                -- Equal delimiters
                THEN String::JoinFromList(AsList($group.day, $group.month, $group.year), ".")
            ELSE NULL
        END;
    };

    RETURN CASE
        WHEN $dd_yy._0 IS NOT NULL THEN $to_date($dd_yy)
        WHEN $yy_dd._0 IS NOT NULL THEN $to_date($yy_dd)
        ELSE NULL
    END;
};


$number_repeats = "5";
$_digits_repeats_pattern = String::ReplaceAll("0{n,}|1{n,}|2{n,}|3{n,}|4{n,}|5{n,}|6{n,}|7{n,}|8{n,}|9{n,}", "n", $number_repeats);
$_grep_digits_repeats = Re2::Grep($_digits_repeats_pattern);

$is_bad_phone = ($phone) -> {
    RETURN $_grep_digits_repeats($phone)
};

$WEBVISOR_MINYEAR = 1946;
$WEBVISOR_MAXYEAR = 2000;

$_date_parser = DateTime::Parse("%Y.%m.%d");

$is_bad_date = ($date) -> {
    $dt = $_date_parser($date);
    RETURN IF(
        $dt IS NULL,
        True,
        DateTime::GetYear($dt) < $WEBVISOR_MINYEAR OR DateTime::GetYear($dt) > $WEBVISOR_MAXYEAR
    );
};

$_url_login_tokens = [
    "login",
    "logon",
    "account",
    "user",
    "auth",
    "sign",
    "ident",
    "regist",
    "voyti",
    "vojti",
    "restore",
    "recovery",
    "forgot",
    "reset",
    "password",
];

$_field_login_tokens = ListExtend($_url_login_tokens, ["reg", "log", "lgn"]);


$_url_login_pattern = "(" || String::JoinFromList($_url_login_tokens, "|") || ")";
$_findAndConsume = Re2::FindAndConsume($_url_login_pattern);

$get_url_login_tokens = ($url) -> {
    RETURN ListUniq(ListExtend($_findAndConsume(Url::Parse($url).Path), $_findAndConsume(Url::Parse($url).Query)));
};

$_is_contain = ($field, $token) -> ( String::Contains(String::AsciiToLower($field), $token) );

$get_field_login_tokens = ($field_id, $field_name) -> {
    RETURN ListFilter($_field_login_tokens, ($item) -> ( $_is_contain($field_id, $item) OR $_is_contain($field_name, $item) ));
};

$is_login = ($url, $field_id, $field_name) -> ( ListHasItems($get_url_login_tokens($url)) OR ListHasItems($get_field_login_tokens($field_id, $field_name)) );


EXPORT
    $wv_parse_email,
    $wv_parse_phone,
    $wv_parse_date,
    $id_symbols_only,
    $is_bad_phone,
    $is_bad_date,
    $get_url_login_tokens,
    $get_field_login_tokens,
    $is_login
;
