#pragma once

#include <util/generic/string.h>
#include <google/protobuf/descriptor.h>
#include <library/cpp/protobuf/yql/descriptor.h>
#include <metrika/proto/webvisor/recorder_proto.pb.h>
#include <metrika/proto/webvisor/pages.pb.h>
#include <metrika/proto/webvisor/events.pb.h>

namespace NCrypta {
    TString WebvisorGenerateAttribute(const TString& type) {
        using namespace ru::yandex::metrika::wv2::proto;
        if (type == "full") {
            return GenerateProtobufTypeConfig<BufferWrapper>();
        } else if (type == "event") {
            return GenerateProtobufTypeConfig<Event>();
        } else if (type == "page") {
            return GenerateProtobufTypeConfig<Page>();
        } else {
            return "";
        }
    }
}
