from __future__ import print_function

from crypta.lib.python.yql_runner.base_parser import BaseParser


class YuidInfoMonthAggregator(BaseParser):

    """ Aggregate yuid logs for month """

    QUERY_TEMPLATE = "yuid_info_month.sql.j2"

    def __init__(self, date_start, date_end, **kwargs):
        super(YuidInfoMonthAggregator, self).__init__(date=date_end, **kwargs)
        self.date_start = date_start
        self.date_end = date_end

    def get_context_data(self, **kwargs):
        context = super(YuidInfoMonthAggregator, self).get_context_data(**kwargs)
        context.update(date_start=self.date_start, date_end=self.date_end)
        return context
