{% if not is_embedded %}
PRAGMA Library = 'aggregation_lib.sql';
PRAGMA Library = 'metrica_lib.sql';
{% endif %}

PRAGMA SimpleColumns;

IMPORT {% if is_embedded %}.lib.{% endif %}aggregation_lib SYMBOLS
    $aggregate_uniq_arrays,
    $aggregate_sum_yson_dicts,
    $dump_as_dict_int
;

IMPORT {% if is_embedded %}.lib.{% endif %}metrica_lib SYMBOLS
    $get_main_regions
;

$get_ip_activity_type = ($yandexuid_creation_date, $dates) -> {
    $dates_count = NVL(ListLength($dates), 0);
    $last_date = $dates[0];
    return
        CASE
            WHEN $dates_count == 0
            THEN 'not_active'
            WHEN $dates_count == 1 and $last_date == $yandexuid_creation_date
            THEN 'private'
            WHEN $dates_count == 1 and $last_date != $yandexuid_creation_date
            THEN 'one_day'
            ELSE 'active'
        END;
};

-- PRAGMA yt.MaxRowWeight = '32M';

-- ========================================================================= --

$date_start = '{{ date_start }}';
$date_end = '{{ date_end }}';

-- tables to use
$crypta_ids_storage_dir = '{{ ids_storage_dir }}';
$crypta_graph_dir = '{{ graph_output_dir }}';
$crypta_profiles_export_dir = '{{ crypta_profiles_export_dir }}';

$profiles_for_14days = $crypta_profiles_export_dir || '/profiles_for_14days';

-- output tables
$ids_storage_clean_table = $crypta_ids_storage_dir || '/yandexuid/yuid_with_all_info_no_socdem';
$ids_storage_light_table = $crypta_ids_storage_dir || '/yandexuid/yuid_with_all_light_by_yandexuid';
$ids_storage_compatibility_with_socdem_table = $crypta_ids_storage_dir || '/yandexuid/yuid_with_all_info';

-- ========================================================================= --

$yuid_info_daily_tables = (
    SELECT * FROM RANGE(
        $crypta_graph_dir,
        $date_start,
        $date_end,
        'yuid_raw/yuid_with_info'
    )
);

$aggregate_uniq_arrays_limited = AggregateFlatten(
    AggregationFactory("AGGREGATE_LIST_DISTINCT", 10000));

$aggregate = (
    SELECT
        yuid,
        SOME(yuid_creation_date) as yuid_creation_date,

        MAX_BY(ua_profile, IF(ua_profile IS NOT NULL, last_ts)) as ua_profile,
        MAX_BY(user_agent, IF(user_agent IS NOT NULL, last_ts)) as user_agent,
        MAX_BY(wapprofile, IF(wapprofile IS NOT NULL, last_ts)) as wapprofile,
        MAX_BY(browser, IF(browser IS NOT NULL, last_ts)) as browser,
        MAX_BY(browser_version, IF(browser_version IS NOT NULL, last_ts)) as browser_version,

        AGGREGATE_BY(multi_user_agent ?? [], $aggregate_uniq_arrays_limited) ?? [] as multi_user_agent,

        AGGREGATE_LIST(id_date) as dates,
        -- MAX(last_ts) as last_ts,
        MAX(id_date) as last_ts,

        AGGREGATE_BY(sources ?? [], $aggregate_uniq_arrays) ?? [] as sources,

        AGGREGATE_BY(log_region_ids, $aggregate_sum_yson_dicts) as log_region_ids,
        AGGREGATE_BY(ip_region_ids, $aggregate_sum_yson_dicts) as ip_region_ids,
        $get_main_regions(AGGREGATE_BY(ip_region_ids, $aggregate_sum_yson_dicts)) AS main_regions,

    FROM $yuid_info_daily_tables
    GROUP BY yuid
);

$common_fields = (
  SELECT
      yuid,
      last_ts,
      dates,
      yuid_creation_date,
      $get_ip_activity_type(yuid_creation_date, dates) as ip_activity_type,

      ua_profile,
      user_agent as ua,
      wapprofile,
      browser,
      browser_version,
      multi_user_agent,

      $dump_as_dict_int(
          log_region_ids
      ) as log_region_ids,

      $dump_as_dict_int(
          ip_region_ids
      ) as ip_region_ids,

      main_regions.main_region_country as main_region_country,
      main_regions.main_region_obl as main_region_obl,
      main_regions.main_region_city as main_region_city,
      main_regions.main_region as main_region,

  FROM $aggregate
);


INSERT INTO $ids_storage_clean_table WITH TRUNCATE
SELECT
    a.yuid as id,
    'yandexuid' as id_type,
    'yuid_with_all' as source,
    a.* WITHOUT yuid
FROM $common_fields as a
order by id, id_type;


-- Yuid with socdem compatibility
INSERT INTO $ids_storage_compatibility_with_socdem_table WITH TRUNCATE
SELECT
    a.yuid as id,
    'yandexuid' as id_type,
    'yuid_with_all' as source,
    b.gender as gender,
    b.age_segments as age_segments,
    b.income_segments as income_segments,
    a.* WITHOUT a.yuid
FROM $common_fields as a
LEFT JOIN $profiles_for_14days as b
ON a.yuid == CAST(b.yandexuid as String)
order by id, id_type;


INSERT INTO $ids_storage_light_table WITH TRUNCATE
SELECT
    Unwrap(CAST(yuid AS Uint64)) AS yandexuid,
    CAST(main_region AS Uint64) AS main_region,
    CAST(main_region_country AS Uint64) AS main_region_country,
    CAST(main_region_city AS Uint64) AS main_region_city,
    ua_profile,
    ip_activity_type
FROM $common_fields
ORDER BY yandexuid;
