package ru.yandex.crypta.graph.engine.exp.stats.ops;

import java.io.Serializable;

import ru.yandex.bolts.collection.IteratorF;
import ru.yandex.crypta.graph.engine.proto.TStatsOptions;
import ru.yandex.crypta.graph2.dao.yt.bendable.YsonCachedSerializerSupport;
import ru.yandex.crypta.graph2.dao.yt.proto.NativeProtobufOneOfMessageEntryType;
import ru.yandex.crypta.graph2.matching.human.proto.UseMergeStrategyReducerInRec;
import ru.yandex.crypta.graph2.matching.human.workflow.merge.ops.helper.GraphInfoProtoRecsParser;
import ru.yandex.crypta.graph2.model.matching.component.GraphInfo;
import ru.yandex.crypta.graph2.model.matching.component.score.ComponentScoringStrategy;
import ru.yandex.crypta.graph2.model.matching.merge.MergeKey;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;
import ru.yandex.inside.yt.kosher.impl.operations.utils.ReducerWithKey;
import ru.yandex.inside.yt.kosher.operations.Statistics;
import ru.yandex.inside.yt.kosher.operations.Yield;
import ru.yandex.inside.yt.kosher.tables.YTableEntryType;
import ru.yandex.inside.yt.kosher.ytree.YTreeMapNode;

public class CollectStatsByMergeKeyReducer extends YsonCachedSerializerSupport implements ReducerWithKey<UseMergeStrategyReducerInRec, YTreeMapNode, MergeKey>, Serializable {

    private ComponentScoringStrategy strategy;

    public CollectStatsByMergeKeyReducer() {

        TStatsOptions options = TStatsOptions.newBuilder().setCrossDeviceWeight(7.5).build();
        strategy = new TestComparisonStrategy(options);
    }

    @Override
    public MergeKey key(UseMergeStrategyReducerInRec entry) {
        if (entry.hasComponentToMergeRec1()) {
            var table = entry.getComponentToMergeRec1();
            return new MergeKey(table.getMergeKey(), table.getMergeKeyType());
        } else if (entry.hasEdgeBetweenComponentsRec2()) {
            var table = entry.getEdgeBetweenComponentsRec2();
            return new MergeKey(table.getMergeKey(), table.getMergeKeyType());
        } else {
            throw new IllegalArgumentException("Rec type is not supported " + entry);
        }
    }
    @Override
    public void reduce(MergeKey mergeKey, IteratorF<UseMergeStrategyReducerInRec> entries, Yield<YTreeMapNode> yield,
            Statistics statistics)
    {
        GraphInfoProtoRecsParser parser = new GraphInfoProtoRecsParser();
        GraphInfo graphInfo = parser.parseInput(entries);

        for (var component : graphInfo.components.values()) {
            MetricsTree metricsTree = strategy.scoreTree(component, graphInfo);
            ComponentScore score = new ComponentScore(component.getCryptaId(), metricsTree);
            yield.yield(serialize(score));
        }
    }

    @Override
    public YTableEntryType<UseMergeStrategyReducerInRec> inputType() {
        return new NativeProtobufOneOfMessageEntryType<>(
                UseMergeStrategyReducerInRec.newBuilder(), true
        );
    }

}
