package ru.yandex.crypta.graph.engine.exp.stats.ops;

import ru.yandex.bolts.collection.Option;
import ru.yandex.crypta.graph2.model.matching.score.MetricsTree;
import ru.yandex.inside.yt.kosher.impl.ytree.object.FieldsBindingStrategy;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeField;
import ru.yandex.inside.yt.kosher.impl.ytree.object.annotation.YTreeObject;


@YTreeObject(bindingStrategy = FieldsBindingStrategy.ANNOTATED_ONLY)
public class ComponentScore {

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private String cryptaId;

    @YTreeField
    @SuppressWarnings("UnusedVariable")
    private Option<MetricsTree> scoreGain = Option.empty();


    public ComponentScore(String cryptaId, MetricsTree scoreGain) {
        this.cryptaId = cryptaId;
        this.scoreGain = Option.of(scoreGain);
    }

}
