#pragma once
#include <crypta/graph/engine/graph/proto/graph_stats.pb.h>
#include "graph.h"
#include "hm.h"

namespace NCrypta::NGraphEngine::NAlgo {

    TVector<NCrypta::NGraphEngine::NCustomView::TEdge> FindBridges(const TCommonGraph &graph);

    TVector<NCrypta::NGraphEngine::NInnerView::TEdge> FindBridges(const NInnerView::TGraph& graph);

    TVector<ui64> FindTwoEdgeConnectedComponents(const NInnerView::TGraph& graph);

    TClusteringCoefficient ComputeClusteringCoefficient(const TCommonGraph& graph, const THumanMatchingTypes& types);

    TClusteringCoefficient ComputeClusteringCoefficient(const TCommonGraph& graph);

    TGraphStats ComputeGraphStats(const TCommonGraph& graph);

}
