#pragma once
#include <crypta/graph/engine/proto/graph.pb.h>
#include <crypta/graph/engine/proto/info.pb.h>
#include <crypta/lib/native/identifiers/lib/id_types/all.h>
#include <crypta/lib/native/identifiers/lib/generic.h>
#include <crypta/graph/soup/config/cpp/soup_config.h>
#include <library/cpp/disjoint_sets/disjoint_sets.h>
#include <util/generic/vector.h>
#include <util/generic/hash.h>
#include <util/stream/output.h>
#include <utility>


namespace NCrypta::NGraphEngine {
        namespace NCustomView {
            struct TVertex {
                // canonical view of vertex
                EIdType Type;
                TString Value;
                bool operator==(const TVertex& other) const {
                    return Type == other.Type && Value == other.Value;
                }
            };

            struct TVertexHasher {
                size_t operator()(const TVertex& vertex) const {
                    return CombineHashes((ui64)vertex.Type, ComputeHash(vertex.Value));
                }
            };

            struct TEdge {
                TVertex Vertex1;
                TVertex Vertex2;
                NCrypta::NGraphEngine::TEdge Edge{};
                bool operator==(const TEdge& other) const {
                    return (Vertex1 == other.Vertex1 && Vertex2 == other.Vertex2) ||
                           (Vertex1 == other.Vertex2 && Vertex2 == other.Vertex1);
                }
            };
        }

        namespace NInnerView {
            struct TEdge {
                ui64 Vertex1 = 0;
                ui64 Vertex2 = 0;
                double Weight = 0.;
                bool IsStrong = false;
            };
            struct TVertex {
                ui64 Index;
                NCustomView::TVertex CustomVertex;
            };

            struct TGraph {
                THashMap<NCustomView::TVertex, ui64, NCustomView::TVertexHasher> IdToVertexIndex;
                THashMap<ui64, TVertex> Vertices;
                TVector<TVector<TEdge>> Edges;

                bool IsAdjacent(ui64 vertex1, ui64 vertex2) const;
            };
        }

        class TCommonGraph {
        // undirected graph
        public:
            TCommonGraph() : Graph() {}

            TCommonGraph(const TGraph& graph, bool forceEdgesStrong=false);

            void AddEdges(const TVector<NCustomView::TEdge> &edges);

            void AddEdge(const NCustomView::TEdge& edge);

            ui64 AddVertex(const NCustomView::TVertex& vertex);

            ui64 size() const;

            const NInnerView::TGraph& GetInnerGraph() const;

            TVector<NCustomView::TEdge> ConvertToCustomView(const TVector<NInnerView::TEdge>& edges) const;

            NCustomView::TVertex ConvertToCustomView(ui64 vertex) const;

            TVector<NCustomView::TVertex> ConvertToCustomView(const TVector<NInnerView::TVertex>& vertices) const;

        private:
            NInnerView::TGraph Graph{};

            void AddEdge(ui64 firstVertexId, ui64 secondVertexId, const NCrypta::NGraphEngine::TEdge& edge, bool makeEdgeStrong=false);
            ui64 GetOrCreateIndex(const NCustomView::TVertex& vertex);
        };
}



template<>
void Out<NCrypta::NGraphEngine::NInnerView::TGraph>(IOutputStream& out, const NCrypta::NGraphEngine::NInnerView::TGraph& graph);

template<>
void Out<NCrypta::NGraphEngine::NInnerView::TVertex>(IOutputStream& out, const NCrypta::NGraphEngine::NInnerView::TVertex& vertex);

template<>
void Out<NCrypta::NGraphEngine::NCustomView::TVertex>(IOutputStream& out, const NCrypta::NGraphEngine::NCustomView::TVertex& vertex);

template<>
void Out<NCrypta::NGraphEngine::NInnerView::TEdge>(IOutputStream& out, const NCrypta::NGraphEngine::NInnerView::TEdge& edge);
